import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { MultiSelect, Select } from 'amos-framework';
import { SingleQueryEnum } from 'amos-processor/lib/config/queryEnum';
import { queryRiskLevelEumListAction } from '../../../../services/bizService';
import { dangerStatus, equipmentStatus } from '../../conf';

const Option = Select .Option;
const selectKeyEum = { riskSource: 'riskLevel', equipment: 'equipType', danger: 'dangerLevel' };
/**
 * 检索-过滤栏
 *
 * @class Filter
 * @extends {Component}
 */
class Filter extends Component {

  static propTypes = {
    onFilterChange: PropTypes.func,
    type: PropTypes.string
  };

  constructor(props) {
    super(props);
    this.state = {
      type: '',
      riskSourceLevel: []
    };
  }

  componentDidMount() {
    this.getRiskLevelEumData();
  }

  componentWillReceiveProps = (nextProps) => {
    const { type } = nextProps;
    this.setState({ type });
  }

  getRiskLevelEumData = () => {
    queryRiskLevelEumListAction().then(data => {
      this.setState({ riskSourceLevel: data });
    });
  }


  // getRiskReander = () => {
  //   const { onFilterChange } = this.props;
  //   const { routeList } = this.state;
  //   return (
  //     <div className="datapane-filter-content">
  //       <Select
  //         className="datapane-filter-item datapane-filter-select"
  //         data={routeList}
  //         renderOption={item => <Option className="datapane-select-option" value={item.name}>{item.name}</Option>}
  //         defaultOption={<Option className="datapane-select-option">全部路线</Option>}
  //         onChange={(e) => onFilterChange('route', e, SingleQueryEnum.EQUAL)}
  //       />
  //       <Select
  //         className="datapane-filter-item datapane-filter-select"
  //         data={riskSourceStatus}
  //         renderOption={item => <Option className="datapane-select-option" value={item.key}>{item.label}</Option>}
  //         defaultOption={<Option className="datapane-select-option">全部</Option>}
  //         onChange={(e) => onFilterChange('nodeState', e, SingleQueryEnum.EQUAL)}
  //       />
  //     </div>
  //   );
  // }

  getReanderByType = (type) => {
    const { onFilterChange } = this.props;
    return (
      <div className="datapane-filter-content">
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={this.getDataByType(type) || []}
          renderOption={item => <Option className="datapane-select-option" value={item.key || item.id}>{item.label || item.level}</Option>}
          defaultOption={<Option className="datapane-select-option">全部</Option>}
          onChange={(e) => onFilterChange(selectKeyEum[type], e, 'EQUAL')}
        />
      </div>
    );
  }

  getDataByType =(type)=>{
    const { riskSourceLevel } = this.state;
    switch (type) {
      case 'riskSource':
        return riskSourceLevel;
      case 'equipment':
        return dangerStatus;
      case 'danger':
        return equipmentStatus;
    }
  }

  getFilterRender = (type) => {
    return type ? this.getReanderByType(type) : '';
  }

  render() {
    const { type } = this.state;
    return this.getFilterRender(type);
  }
}

export default Filter;
