import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Connect } from 'amos-framework';
import MinInfo from './MinInfo';
import MaxInfo from './MaxInfo';

const portalConnect = Connect.portalConnect;

class DialogBody extends Component {

  constructor(props) {
    super(props);
    this.state = {
      showMax: props.showMax || false,
      currentKey: ''
    };
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.showMax !== this.state.showMax){
      this.setState({
        showMax: nextProps.showMax
      });
    }
  }

  onClose = () => {
    this.props.closeDialog && this.props.closeDialog();
  }

  onFooterItemClick = (key, e) => {
    this.setState({
      currentKey: key
    });
    this.props.clickFooterItem && this.props.clickFooterItem(key);
  }

  render() {
    const { showMax, currentKey } = this.state;
    const { minInfo, maxContent } = this.props;
    const cls = classNames('dialog-body', {
      'show-body-max': showMax
    });
    return (
      <div className={cls}>
        <MinInfo {...minInfo} onClose={this.onClose} onFooterItemClick={this.onFooterItemClick} activeKey={currentKey} />
        {showMax && <MaxInfo content={maxContent} />}
      </div>
    );
  }
}

DialogBody.propTypes = {
  minInfo: PropTypes.shape({
    footers: PropTypes.array,
    content: PropTypes.node,
    table: PropTypes.node
  }),
  maxContent: PropTypes.node,
  showMax: PropTypes.bool,
  closeDialog: PropTypes.func,
  clickFooterItem: PropTypes.func
};

export default portalConnect(DialogBody, {
  key: 'dialog-body-portal',
  className: 'dialog-body-portal-wrapper'
});
