import { Toast, Paragraph } from 'amos-framework';
import React from 'react';
import '../../../styles/view/3dview/notification.scss';
import RiskSourceDetailModal from '../points/dialogModel/RiskSourceDetailModal';

const conf = {
  duration: 5
};

function openRiskWarningModel(id) {
  Toast.open({
    title: '风险触发预警详情',
    content: <RiskSourceDetailModal riskSourceId={id} />,
    placement: 'topMiddle',
    icon: false,
    className: 'risk-warn-toast',
    duration: null
  });
}

export default function globalMsg(msg){
  const { title, content, duration = conf.duration, bizclassName, excuteState } = msg.data;
  const { id } =  msg.bizObj;
  if (title && content) {
    if (excuteState === '2') {
      Toast.success({
        title,
        content: <Paragraph html={content} />,
        placement: 'topMiddle',
        icon: false,
        duration,
        onClick: bizclassName && bizclassName.indexOf('RiskSourceRo') !== -1 ? ()=>openRiskWarningModel(id) : ()=>{}
      });
    } else {
      Toast.error({
        title,
        content: <Paragraph html={content} />,
        placement: 'topMiddle',
        icon: false,
        duration,
        onClick: bizclassName && bizclassName.indexOf('RiskSourceRo') !== -1 ? ()=>openRiskWarningModel(id) : ()=>{}
      });
    }
  }
}
