import React, { Component } from 'react';
import { pointInfoAction } from 'SERVICES/3dService';
import { CONSTS } from 'CONSTS/storageConsts';
import { queryRoutePlanPointAction } from 'SERVICES/checkInfoService';
import { Modal } from 'amos-framework';
import Dialog from './../dialog';
import RiskContent from './RiskContent';
import { tirggerTransTopic } from './../dataProcessor';
import RiskContentTable from './dialogModel/RiskContentTable';
import EquipDetailModal from './dialogModel/EquipDetailModal';
import DangerDetailModal from './dialogModel/DangerDetailModal';
import RiskSourceDetailModal from './dialogModel/RiskSourceDetailModal';


const footers = [
  { key: 'details', icon: 'number-more', text: '详情' },
  { key: 'danger', icon: 'danger', text: '隐患' }
];
const dialogEum = { riskSource: '风险详情',danger: '隐患详情',equipment: '设备设施' };


class PointDialog extends Component {
  constructor(props) {
    super(props);
    this.state = {
      open: false,
      showRight: false,
      rightContent: null,
      markerData: {},
      modal: false
    };
  }

  onOpenClick = marker => {
    const { id, type } = marker.extData || {};
    if (type === 'risk'){
      this.setState(
        {
          open: true
        },
        () => {
          pointInfoAction(id, type).then(d => {
            d.markerExtData = { dialogId: id, type };
            this.setState({ markerData: d });
          });
          this.getTableData(id);
        }
      );
    } else if (type in dialogEum){
      let markerData = {};
      markerData.markerExtData = { dialogId: id, type };
      this.setState({ markerData,modal: true });
    }
  };

  onDialogClose = () => {
    this.setState({
      open: false,
      showRight: false,
      rightContent: null,
      markerData: {}
    });
  };


  getTargetInfo = (key) => {
    const { markerData = {} } = this.state;
    return markerData.name;
    // const info = markerData.info || [];
    // return (info.find(i => i.key === key) || {}).value;
  }

  clickFooterItem = key => {
    const { markerData } = this.state;
    // 如果点击详情则和业务屏交互
    const detailParams = {
      ...markerData.markerExtData,
      detailForw: key
    };
    if (key === 'details') {
      tirggerTransTopic(CONSTS.forward, { details: detailParams, dateTime: Date.now() });
    } else if (key === 'danger') {
      const name = this.getTargetInfo('name');
      tirggerTransTopic(CONSTS.forward, {
        name,
        details: detailParams,
        dateTime: Date.now()
      });
    } else if (key === 'record') {
      tirggerTransTopic(CONSTS.forward, { details: detailParams, dateTime: Date.now() });
    }
  };

  tirggerTransBussiness =(id, type)=>{
    switch (type){
      case 'riskSource':
        tirggerTransTopic(CONSTS.forward, { details: { type: 'riskSource',detailForw: type, dialogId: id }, dateTime: Date.now() });
        break;
    }
  }


  onCheckStatusClick =(record) => {
    const { markerData } = this.state;
    const detailParams = {
      ...markerData.markerExtData,
      detailForw: 'record',
      checkId: record.id
    };
    tirggerTransTopic(CONSTS.forward, { details: detailParams, dateTime: Date.now() });
  }

  getTargetInfo = (key) => {
    const { markerData = {} } = this.state;
    const info = markerData.info || [];
    return (info.find(i => i.key === key) || {}).value;
  }

  getContext =(markerData)=>{
    const { type, dialogId, objType } = markerData.markerExtData || {};
    let obj = {};
    switch (type) {
      case 'equipment':
        obj = <EquipDetailModal type='equipment' objType={objType} dialogId={dialogId} />;
        break;
      case 'danger':
        obj = <DangerDetailModal  type='danger' riskSourceId={dialogId} />;
        break;
      case 'riskSource':
        obj = <RiskSourceDetailModal type='riskSource' riskSourceId={dialogId} tirggerTransTopic={tirggerTransTopic} />;
        break;
      default:
        console.log('不支持的类型');
    }
    return obj;
  }

  getTableData =(pointId) =>{
    pointId && queryRoutePlanPointAction([{ name: 'pointID',value: pointId }]).then(data => {
      this.setState({ dataList: data });
    });
  }

  tirggerBussines = marker => {
    const { id, type } = marker.extData || {};
    if (type === 'riskSource') {
      this.tirggerTransBussiness(id, type);
    }
  }

  cancel = () => {
    this.setState({ modal: false });
  }

  clickFooterItem = key => {
    const { markerData } = this.state;
    // 如果点击详情则和业务屏交互
    const detailParams = {
      ...markerData.markerExtData,
      detailForw: key
    };
    if (key === 'details') {
      tirggerTransTopic(CONSTS.forward, { details: detailParams, dateTime: Date.now() });
    } else if (key === 'danger') {
      const name = this.getTargetInfo('name');
      tirggerTransTopic(CONSTS.forward, {
        name,
        details: detailParams,
        dateTime: Date.now()
      });
    } else if (key === 'record') {
      tirggerTransTopic(CONSTS.forward, { details: detailParams, dateTime: Date.now() });
    }
  }

  render() {
    const { open, showRight, rightContent, markerData, modal, dataList } = this.state;
    const { type,dialogId } = markerData.markerExtData || {};
    let minInfo = {
      footers,
      content: <RiskContent markerData={markerData} />,
      table: <RiskContentTable  pointId={dialogId} dataList={dataList} onCheckStatusClick={this.onCheckStatusClick} fetchData={this.getTableData} />
    };
    return (
      <div>
        {
          <Dialog
            visible={open}
            minInfo={minInfo}
            showMax={showRight}
            maxContent={rightContent}
            closeDialog={this.onDialogClose}
            clickFooterItem={this.clickFooterItem}
          />
        }
        {
         type && <Modal
           header={dialogEum[type]}
           visible={modal}
           className={type === 'riskSource' || type === 'danger'  ? 'risk-warn-modal' : 'point-dialog-modal'}
           destroyContent
           content={this.getContext(markerData)}
           noDefaultFooter
           onCancel={this.cancel}
          />
        }
      </div>
    );
  }
}

export default PointDialog;
