import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col } from 'amos-framework';
import Value from './../common/Value';

class RiskContent extends Component {
  static propTypes = {
    markerData: PropTypes.object
  };

  static defaultProps = {
    markerData: {}
  };

  constructor(props) {
    super(props);
    this.state = {};
  }

  render() {
    const { markerData } = this.props;
    // const { info = [] } = markerData || {};
    return (
      <Row className="point-detail-table ">
        <Row className="point-detail-table-row1">
          <Col className="colTitle">编号</Col>
          <Col className="colValue">{markerData.no}</Col>
          <Col className="colTitle">名称</Col>
          <Col className="colValue">{markerData.name}</Col>
          <Col className="colTitle">状态</Col>
          <Col className="colValue">{markerData.realTimeStatus}</Col>
        </Row>
        <Row className="point-detail-table-row2">
          <Col className="colTitle">责任部门</Col>
          <Col className="colValue">{markerData.groupName || ''}</Col>
          <Col className="colTitle">责任人</Col>
          <Col className="colValue">{markerData.realName || ''}</Col>
          <Col className="colTitle">联系方式</Col>
          <Col className="colValue">{markerData.loginName || ''}</Col>
        </Row>
      </Row>
      // <Row className="point-detail-table ">
      //   <Row className="point-detail-table-row1">
      //     <Col className="colTitle">编号</Col>
      //     <Col className="colValue">{(info.find(i => i.key === 'label') || {}).value}</Col>
      //     <Col className="colTitle">名称</Col>
      //     <Col className="colValue">{(info.find(i => i.key === 'name') || {}).value}</Col>
      //     <Col className="colTitle">状态</Col>
      //     <Col className="colValue">{(info.find(i => i.key === 'status') || {}).value}</Col>
      //   </Row>
      //   <Row className="point-detail-table-row2">
      //     <Col className="colTitle">责任部门</Col>
      //     <Col className="colValue">{(info.find(i => i.key === 'department') || {}).value}</Col>
      //     <Col className="colTitle">责任人</Col>
      //     <Col className="colValue">{(info.find(i => i.key === 'chargeUser') || {}).value}</Col>
      //     <Col className="colTitle">联系方式</Col>
      //     <Col className="colValue">{(info.find(i => i.key === 'contact') || {}).value}</Col>
      //   </Row>
      // </Row>
    );
  }
}

export default RiskContent;
