import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosGridTable from './../../../bizview/common/tableComponent/table/AmosGridTable';
import { dangerDetailAction } from '../../../../services/bizService';

const checkListColumns = (self) => {
  return [
    {
      title: '隐患名称',
      dataIndex: 'name',
      key: 'name',
      width: '60%'
    },{
      title: '隐患等级',
      dataIndex: 'level',
      key: 'level',
      width: '20%'
    },{
      title: '治理人',
      dataIndex: 'executor',
      key: 'executor',
      width: '10%'
    },{
      title: '状态',
      dataIndex: 'status',
      key: 'status',
      width: '10%'
    }
  ];
};

/**
 * 隐患详情
 *
 * @class DangerDetailModal
 * @extends {Component}
 */
class DangerDetailModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedRows: [],
      selectedRowKeys: [],
      data: {}
    };
  }

  componentDidMount(){
    const { riskSourceId } = this.props;
    riskSourceId && this.queryDangerDetail(parseInt(riskSourceId));
  }

  queryDangerDetail =(riskSourceId)=>{
    dangerDetailAction(riskSourceId).then(data =>{
      this.setState({ data });
    });
  }

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  render() {
    const { data = {} } = this.state;
    return (
      <div className="risk-warn">
        <div className="risk-warn-header">
          <span style={{ fontWeight: 'bold' }}>风险编号：</span>
          <span>{data.code || ''}&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span>
          <span style={{ fontWeight: 'bold' }}>风险名称：</span>
          <span>{data.name || ''}&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span>
          <span style={{ fontWeight: 'bold' }}>级别：</span>
          <span>{data.riskLevel || ''}</span>
        </div>
        <div className="risk-warn-table">
          <AmosGridTable
            columns={checkListColumns(this)}
            getTableDataAction={()=>{}}
            callBack={this.reload}
            isPageable={false}
            isChecked={false}
            dataList={data.dangerDetails || []}
          />
        </div>
      </div>
    );
  }
}

DangerDetailModal.propTypes = {
  riskSourceId: PropTypes.string
};


export default DangerDetailModal;
