import { initView3DFromBizAction } from './../../services/bizService';

export const dealRiskSourceChange = (instance,riskSourceId,type)=>{
  initView3DFromBizAction(type).then(data=>{
    const { markers } = instance.state;
    if (data.length > 0){
      let needUpdate = false;
      const newArr = data.map(ma => {
        if (parseInt(ma.id) === parseInt(riskSourceId)){
          needUpdate = true;
          return {
            ...ma,
            visible: true //控制点的显示：显示
          };
        } else {
          ma.visible = false;//控制点的显示：不显示
        }
        return ma;
      });
      if (needUpdate){
        markers[type] = newArr;
        instance.setState({
          markers
        });
      }
    }
  });
};

export const dealRiskSourceFlicker = (instance,riskSourceId,type,status,rate)=>{
  initView3DFromBizAction(type).then(data=>{
    const { markers } = instance.state;
    let needUpdate = false;
    let newArr = [];
    if (data.length > 0){
      newArr = data.map(ma => {
        if (parseInt(ma.id) === parseInt(riskSourceId)){
          needUpdate = true;
          return {
            ...ma,
            visible: true, //控制点的显示：显示
            twinkle: status === 'run' ? true : status === 'stop' ? false : true,//气泡的显示
            rate: rate ? rate : 0 //频率
          };
        } else {
          ma.visible = false;//控制点的显示：不显示
        }
        return ma;
      });
      if (type === 'danger' && status === 'stop') {//隐患停止闪烁动作：如果是原来隐患已经消失，则停止显示隐患点
        const exixtDanger = data.filter(e=>parseInt(e.id) === parseInt(riskSourceId));
        if (exixtDanger.length === 0) {
          needUpdate = true;
          data.forEach(item=>item.visible = false);//控制点的显示：不显示
          newArr = data;
        }
      }
    } else if ( data.length === 0 && type === 'danger' && status === 'stop') {
      const dangerArry = markers.danger;
      newArr = dangerArry.map(ma=>{
        if (parseInt(ma.id) === parseInt(riskSourceId)) {
          needUpdate = true;
          return {
            ...ma,
            showInfo: false,
            visible: false//控制点的显示：显示
          };
        }
      });
    }
    if (needUpdate){
      markers[type] = newArr;
      instance.setState({
        markers
      });
    }
  });
};

export const dealTaskworkChange = (instance, taskworkId, type, operate, statusTitle) => {
  if (operate === 'hide') {
    const { markers } = instance.state;
    let needUpdate = false;
    const taskWork = markers[type];
    const newArr = taskWork && taskWork.map(ma => {
      if (parseInt(ma.id) === parseInt(taskworkId)){
        needUpdate = true;
        return {
          ...ma,
          showInfo: operate === 'hide' ? false : true,
          visible: operate === 'hide' ? false : true //控制点的显示：显示
        };
      }
    });
    if (needUpdate){
      markers[type] = newArr;
      instance.setState({
        markers
      });
    }
  } else {
    initView3DFromBizAction(type).then(data => {
      const { markers } = instance.state;
      if (data.length > 0){
        let needUpdate = false;
        const newArr = data.map(ma => {
          if (parseInt(ma.id) === parseInt(taskworkId)){
            needUpdate = true;
            return {
              ...ma,
              showInfo: operate === 'show' ? true : false,
              title: statusTitle,
              visible: operate === 'show' ? true : false //控制点的显示：显示
            };
          } else {
            ma.visible = false;//控制点的显示：不显示
          }
          return ma;
        });
        if (needUpdate){
          markers[type] = newArr;
          instance.setState({
            markers
          });
        }
      }
    });
  }
};
