import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, SidePane } from 'amos-framework';
import AmosWebSocket from 'amos-websocket';
import * as endConf from 'amos-processor/lib/config/endconf';
import ReservePlan from './reservePlan/index';
import PlanDetail from './plan/PlanDetail';
import RecordView from './preControl/records/RecordView';
import StepView from './preControl/steps/StepView';
import TopView from './preControl/topNews/TopView';
import MonitorView from './preControl/monitor/MonitorView';
import { eventTopics } from './consts';

const eventConnect = Connect.eventConnect;
const AmosConfig = endConf.AmosConfig;

const sidepaneStyles = {
  topArea: {
    left: '50%',
    top: 0,
    transform: 'translateX(-50%)'
  },
  operatePos: {
    left: '50%',
    bottom: 30,
    transform: 'translateX(-50%)',
    zIndex: 10
  }
};

/**
 * 层加载池
 *
 * @class LayerPool
 * @extends {Component}
 */
@eventConnect
class LayerPool extends Component {
  constructor(props) {
    super(props);
    this.state = {
      displayDetail: true,
      stepMonitorAreaShow: false,
      fireResourceData: null,
      detailPos: {
        right: 20,
        top: 21,
        planStartTop: 46,
        bottom: 154
      },
      recordPos: {
        left: 21,
        bottom: 33
      },
      setupPos: {
        left: 21,
        top: 21
      },
      monitorPos: {
        left: 21,
        top: 236
      }
    };
  }

  componentDidMount() {
    this.screenChange();
    this._bindPubSubEvents();
  }

  componentWillReceiveProps(nextProps) {
    this.setState({ planStarted: nextProps.planStarted });
  }

  onCancal = () => {
    this.setState({ displayDetail: false });
  };

  /**
   * 绑定事件
   *
   * @memberof LayerPool
   */
  _bindPubSubEvents = () => {
    this.props.subscribe(eventTopics.plan_detail, (topic, content) => {
      this.setState({ displayDetail: true });
    });
  };

  /**
   * 屏幕改变事件
   *
   * @memberof LayerPool
   */
  screenChange = () => {
    window.addEventListener('resize', this.resize);
  };

  /**
   * 绑定数据
   *
   * @memberof LayerPool
   */
  handleData = data => {
    this.setState({ fireResourceData: data });
  }

  resize = () => {};

  render() {
    const { detailPos, recordPos, setupPos, monitorPos, displayDetail, planStarted } = this.state;
    const { animationProps, planStart, planQuit } = this.props;
    let detailTop = planStarted ? detailPos.top : detailPos.planStartTop;
    let wsURL = `${AmosConfig.wsURI.securityBaseURI}plan`;
    return (
      <div className="layer-pool">
        <AmosWebSocket ref={node => this.aws = node} url={wsURL} onMessage={this.handleData} reconnect debug />
        <SidePane
          className={displayDetail ? 'precontrol-sidePlan-detail-display' : 'precontrol-sidePlan-detail'}
          left={false}
          right={detailPos.right}
          top={detailTop}
          bottom={detailPos.bottom}
          {...animationProps}
        >
          <PlanDetail cancal={this.onCancal} />
        </SidePane>
        <SidePane className='record-view' top={false} left={recordPos.left} bottom={recordPos.bottom} {...animationProps}>
          <RecordView />
        </SidePane>
        <SidePane left={setupPos.left} top={setupPos.top} {...animationProps}>
          <StepView />
        </SidePane>
        <SidePane className='monitor-view' left={monitorPos.left} top={monitorPos.top} {...animationProps}>
          <MonitorView planStart={planStart} />
        </SidePane>
        <SidePane top={false} left={false} style={sidepaneStyles.operatePos} {...animationProps}>
          <ReservePlan />
        </SidePane>
        <SidePane className="rule-pool-topview" top={false} left={false} style={sidepaneStyles.topArea}>
          <TopView planStart={planStart} planQuit={planQuit} planStarted={planStarted} />
        </SidePane>
      </div>
    );
  }
}
LayerPool.propTypes = {
  planStart: PropTypes.func,
  animationProps: PropTypes.any,
  subscribe: PropTypes.func,
  planQuit: PropTypes.func,
  planStarted: PropTypes.bool
};
export default LayerPool;
