import React from 'react';
import PropTypes from 'prop-types';

const Header = props => {

  const { headers, onItemClick, activeKey } = props;
  return (
    <div className="common-header">
      {
        headers.map(f => {
          const cls = activeKey === f.key ? 'common-header-item common-header-item-active' : 'common-header-item';
          return (
            <div key={f.key} className={cls} onClick={(e) => onItemClick(f.key, e)}>
              <p className="header-item-text">{f.text}</p>
            </div>
          );
        })
      }
    </div>
  );
};

Header.propTypes = {
  headers: PropTypes.arrayOf(PropTypes.shape({
    key: PropTypes.string,
    icon: PropTypes.string,
    text: PropTypes.string
  })),
  onItemClick: PropTypes.func,
  activeKey: PropTypes.string
};

export default Header;
