import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select } from 'amos-framework';
import { SingleQueryEnum } from 'amos-processor/lib/config/queryEnum';
import {
  searchRegionListAction,
  initView3DLinkAction,
  getImpEquipmentAction
} from 'SERVICES/3dService';

import { riskSourceLevel , riskSourceStatus, fireResource } from '../../conf';

const Option = Select .Option;
/**
 * 检索-过滤栏
 *
 * @class Filter
 * @extends {Component}
 */
class Filter extends Component {

  static propTypes = {
    onFilterChange: PropTypes.func,
    type: PropTypes.string
  };

  constructor(props) {
    super(props);
    this.state = {
      regionList: [],
      routeList: [],
      impEquiList: [],
      type: ''
    };
  }

  componentDidMount() {
    const { type } = this.props;
    searchRegionListAction().then(d => this.setState({ regionList: d || [], type }));
    initView3DLinkAction().then(d => this.setState({ routeList: d || [] , type }));
    getImpEquipmentAction().then(d => this.setState({ impEquiList: d || [] , type }));
  }

  componentWillReceiveProps = (nextProps) => {
    const { type } = nextProps;
    this.setState({ type });
  }


  getRiskSourceReander = () => {
    const { onFilterChange } = this.props;
    return (
      <div className="datapane-filter-content">
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={riskSourceLevel}
          renderOption={item => <Option className="datapane-select-option" value={item.key}>{item.label}</Option>}
          defaultOption={<Option className="datapane-select-option">全部</Option>}
          onChange={(e) => onFilterChange('dataLevel', e, SingleQueryEnum.EQUAL)}
        />
      </div>
    );
  }

  getRiskReander = () => {
    const { onFilterChange } = this.props;
    const { routeList } = this.state;
    return (
      <div className="datapane-filter-content">
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={routeList}
          renderOption={item => <Option className="datapane-select-option" value={item.name}>{item.name}</Option>}
          defaultOption={<Option className="datapane-select-option">全部路线</Option>}
          onChange={(e) => onFilterChange('route', e, SingleQueryEnum.EQUAL)}
        />
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={riskSourceStatus}
          renderOption={item => <Option className="datapane-select-option" value={item.key}>{item.label}</Option>}
          defaultOption={<Option className="datapane-select-option">全部</Option>}
          onChange={(e) => onFilterChange('nodeState', e, SingleQueryEnum.EQUAL)}
        />
      </div>
    );
  }

  getFireResourceRender = () => {
    const { onFilterChange } = this.props;
    return (
      <div className="datapane-filter-content">
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={fireResource}
          renderOption={item => <Option className="datapane-select-option" value={item.key}>{item.label}</Option>}
          defaultOption={<Option className="datapane-select-option">全部</Option>}
          onChange={(e) => onFilterChange('fireResource', e, SingleQueryEnum.EQUAL)}
        />
      </div>
    );
  }

  getVideoRender = () => {
    const { onFilterChange } = this.props;
    const { impEquiList } = this.state;
    return (
      <div className="datapane-filter-content">
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={impEquiList}
          renderOption={item => <Option className="datapane-select-option" value={item.name}>{item.name}</Option>}
          defaultOption={<Option className="datapane-select-option">全部</Option>}
          onChange={(e) => onFilterChange('impEquipment', e, SingleQueryEnum.EQUAL)}
        />
      </div>
    );
  }

  getFilterRender = () => {
    const { type } = this.state;
    if (type === 'riskSource') {
      return this.getRiskSourceReander();
    } else if (type === 'patrol') {
      return this.getRiskReander();
    } else if (type === 'monitorEquipment') {
      return this.getVideoRender();
    } else if (type === 'video') {
      return this.getVideoRender();
    } else {
      return '';
    }
  }

  render() {
    return this.getFilterRender();
  }
}

export default Filter;
