import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Connect } from 'amos-framework';
import MinInfo from './MinInfo';
import MaxInfo from './MaxInfo';

const portalConnect = Connect.portalConnect;

/**
 * 弹出框内容
 *
 * @class DialogBody
 * @extends {Component}
 */
class DialogBody extends Component {

  constructor(props) {
    super(props);
    this.state = {
      showMax: props.showMax || false,
      currentKey: ''
    };
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.showMax !== this.state.showMax){
      this.setState({
        showMax: nextProps.showMax
      });
    }
  }

  onClose = () => {
    this.props.closeDialog && this.props.closeDialog();
  }

  onItemClick = (key, e) => {
    this.setState({
      currentKey: key
    });
    this.props.clickHeaderItem && this.props.clickHeaderItem(key);
  }

  render() {
    const { showMax, currentKey } = this.state;
    const { minInfo, maxContent } = this.props;
    const cls = classNames('dialog-body', {
      'show-body-max': showMax
    });
    return (
      <div className={cls}>
        <MinInfo {...minInfo} onClose={this.onClose} onItemClick={this.onItemClick} activeKey={currentKey} />
        {showMax && <MaxInfo content={maxContent} />}
      </div>
    );
  }
}

DialogBody.propTypes = {
  minInfo: PropTypes.shape({
    headers: PropTypes.array,
    content: PropTypes.node,
    table: PropTypes.node,
    title: PropTypes.string
  }),
  maxContent: PropTypes.node,
  showMax: PropTypes.bool,
  closeDialog: PropTypes.func,
  clickHeaderItem: PropTypes.func
};

export default portalConnect(DialogBody, {
  key: 'dialog-body-portal',
  className: 'dialog-body-portal-wrapper'
});
