import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Modal } from 'amos-framework';
import AmosWebSocket from 'amos-websocket';
import * as endConf from 'amos-processor/lib/config/endconf';
import PilotController from 'amos-viz/lib/board/PilotController';
import SysWsURL, { completeToken } from 'CONSTS/wsUrlConsts';
import ScreenSaverView from './screenSaver/ScreenSaverView';
import { browserHistory } from 'amos-react-router';
import Three3dView from './View3D';
import { eventTopics } from './consts';
import { MapChart } from 'amos-viz/lib/echarts';
import {fetchJsonAction} from './../../../services/3dService';
import LeftCharts from './indexCharts/leftCharts';
import RightCharts from './indexCharts/rightCharts';

const eventConnect = Connect.eventConnect;
const AmosConfig = endConf.AmosConfig;
const enableScreenSaver = AmosConfig.screenSaverConf.enable;
const delayTime = AmosConfig.screenSaverConf.delayTime;
const chartColor = ['#00A2FF','#19FF00','#959595','#FF8800','#FF0000','#02E3FC','#FFF948','#FFAA00'];

@eventConnect
class IndexChart extends Component {
  constructor(props) {
    super(props);

    this.state = {
      mapChartData: []
    };
    this.eventpool = {
      click: (...args) => {
        let pointData = args[0].data;
        let seriesType = args[0].seriesType;
        if(pointData && pointData.name && pointData.name === '西安'){
					this.props.indexViewChange(true);

        }else if (seriesType === 'lines') {
          // window.localStorage.setItem('cityLine',JSON.stringify(pointData))
          browserHistory.push({pathname: '/biz/defaultRoute',state: { cityLine: JSON.stringify(pointData) }});

        }
      }
    };
  }

  componentDidMount() {
		fetchJsonAction('/src/_mock/chart/indexMap.json',(data) => {
			this.state.mapChartData = data;
			this.setState({
				mapChartData: data || []
			})
		})
	}

  componentWillUnmount() {

  }

  convertData = data => {
    let res = [];
    for (let i = 0; i < data.length; i++) {
			let dataItem = data[i];
			let fromCoord = dataItem[0].position;
			let toCoord = dataItem[1].position;
			if (fromCoord && toCoord) {
				// res.push([{
				//     coord: fromCoord
				// }, {
				//     coord: toCoord
				// }]);
				res.push({
					coords:[
						fromCoord,toCoord
					],
					citys: [dataItem[0].name,dataItem[1].name]
				})
			}
    }
    // console.log(res)
    return res;
  };
  getSeries = data => {
    let series = [];
    for (let i = 0; i < data.length; i++){
      let cityData = data[i].data;
      for (let j = 0; j < cityData.length; j ++) {
        // console.log(cityData[j].name)
        let seriesItem = {
          name: cityData[j].name,
          // name: cityData[j].data.length>0?cityData[j].data[1].name:'',
          type: 'lines',
          zlevel: 2,
          lineStyle: {
						normal: {
							// color:  '#1AFF00',
							color:  chartColor[j],
							width: i === 0?3:1,
							opacity: 0.8,
							curveness: 0.2
						}
          },
          data: this.convertData(cityData[j].data||[])
        };
        let cityPoint = {
					// 目的地标记
					// name: cityData[j].name,
					type: 'effectScatter',
					coordinateSystem: 'geo',
					zlevel: 2,
					rippleEffect: {
							brushType: 'stroke',
							period: 6
					},
					label: {
							normal: {
									show: true,
									position: 'right',
									formatter: '{b}',
									color: '#5FFFFD'
							}
					},
					// symbolSize: function(val) {
					//     return val[2] / 8;
					// },
					symbolSize: 10,
					itemStyle: {
							normal: {
									color: '#1AFF00'
							}
					},
					data: (cityData[j].data||[]).map(function(dataItem) {
						return {
								name: dataItem[1].name,
								value: dataItem[1].position.concat([dataItem[1].value])
						};
          })

        }
        series.push(seriesItem);
        series.push(cityPoint);
      }

    }
    return series;
  }


  render() {
		// console.log(mapChartData)
		let { mapChartData } = this.state
		let cityData = mapChartData;
    let mapOption = {
      // backgroundColor: '#fff',
      title : {
          show: false,
          text: '迁徙图',
          subtext: '--',
          left: 'center',
          textStyle : {
              color: '#fff'
          }
      },
      tooltip : {
          trigger: 'item'
      },
      legend: {
          orient: 'vertical',
          top: 'top',
          left: 'left',
          data:['其他', '正常', '未运行', '告警', '故障', 'MBFE正常', 'MBFE告警', 'MBFE故障'],
          textStyle: {
              color: '#fff'
          },
          // selectedMode: 'single'
      },
      geo: {
          map: '陕西',
          label: {
              emphasis: {
                  show: false
              }
					},
					center: [110.15, 36.07],
          roam: true,
          itemStyle: {
              normal: {
                  areaColor: '#0D2A7D',
                  borderColor: '#00EEFF',
                  borderWidth: 2,
                  // shadowColor: '#151515',
                  // shadowBlur: 50
              },
              emphasis: {
                  areaColor: '#020A42'
              }
          }
      },
      series: this.getSeries(cityData)

    };

    return (
      <div className="content">
        <div className='body-left'>
					<LeftCharts />
        </div>
        <div className='body-center'>
          <MapChart option={mapOption} eventpool={this.eventpool} />
        </div>
        <div className='body-right'>
          {/* <div><img src='/src/assets/bg/indexRight.png' /></div> */}
					<RightCharts />
        </div>
      </div>
    );
  }
}

IndexChart.propTypes = {
  subscribe: PropTypes.func,
  trigger: PropTypes.func
};

export default IndexChart;
