import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Modal } from 'amos-framework';
import * as endConf from 'amos-processor/lib/config/endconf';
import { Row, Col } from 'amos-framework';
import BusinessTable from './businessTable';
import { BottomTableAction } from '../../../../../services/3dService';
import AmosWebSocket from 'amos-websocket';
import SysWsURL, { completeToken } from './../../../../../consts/wsUrlConsts';

const eventConnect = Connect.eventConnect;
const AmosConfig = endConf.AmosConfig;

@eventConnect
class BottomTable extends Component {
  constructor(props) {
    super(props);

    this.state = {
      tableList: {}
    };
  }

  componentDidMount() {
    this.getTableData();
  }

  getTableData = () => {
    BottomTableAction().then(data => {
      this.setState({ tableList: data });
    });
  }

  handleData = (data = {}) => {
    console.log('pay ws data:', data);
    if (data === 'payRefresh'){
      setTimeout(() => {
        this.getTableData();
      }, 2000);
    }
  };

  render() {
    const { tableList } = this.state;
    const wsURL = completeToken(SysWsURL.planTaskURI);
    return (
        <div className='table-bottom'>
          <AmosWebSocket ref={node => this.aws = node} url={wsURL} onMessage={this.handleData} reconnect debug />
          <BusinessTable key={'LRBS'} data={tableList.LRBS} title="累计流入交易(笔数)"/>
          <BusinessTable key={'LCBS'} data={tableList.LCBS} title="累计流出交易(笔数)"/>
          <BusinessTable key={'LRJE'} data={tableList.LRJE} title="累计流入交易金额(亿元)"/>
          <BusinessTable key={'LCJE'} data={tableList.LCJE} title="累计流出交易金额(亿元)"/>
        </div>
    );
  }
}

BottomTable.propTypes = {
  subscribe: PropTypes.func,
  trigger: PropTypes.func
};

export default BottomTable;
