import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Modal } from 'amos-framework';
import * as endConf from 'amos-processor/lib/config/endconf';
import { Row, Col } from 'amos-framework';

const eventConnect = Connect.eventConnect;
const AmosConfig = endConf.AmosConfig;

@eventConnect
class BusinessTable extends Component {
  constructor(props) {
    super(props);

    this.state = {

    };
  }

  componentDidMount() {}

  render() {
    const { data = [], title = '' } = this.props;
    let de = data.find(e=>{ return e.payName === '大额系统'}) || {};
    let xe = data.find(e=>{ return e.payName === '小额系统'}) || {};
    let wy = data.find(e=>{ return e.payName === '网银系统'}) || {};
    //let jr = data.find(e=>{ return e.payName ==="境外系统"}) || {};
    return (
        <div className='business-table' key={this.props.key}>
          <div>{ title }</div>
          <table>
            <tbody>
              <tr className='business-table-header'>
                <td>大额</td>
                <td>小额</td>
                <td>网银</td>
                {/*<td>境外</td>*/}
              </tr>
              <tr className='business-table-body'>
                <td title={de.score || 0 }>{ de.score || 0 }</td>
                <td title={xe.score || 0 }>{ xe.score || 0 }</td>
                <td title={wy.score || 0 }>{ wy.score || 0 }</td>
                {/*<td title={jr.score || 0 }>{ jr.score || 0 }</td>*/}
              </tr>
            </tbody>
          </table>
        </div>
    );
  }
}

BusinessTable.propTypes = {
  subscribe: PropTypes.func,
  trigger: PropTypes.func
};

export default BusinessTable;
