import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Modal } from 'amos-framework';
import * as endConf from 'amos-processor/lib/config/endconf';
import { Row, Col } from 'amos-framework';
import { middleTabletAction, middleHeaderAction } from '../../../../../services/3dService';

const eventConnect = Connect.eventConnect;
const AmosConfig = endConf.AmosConfig;

const imgs = {"技术岗":"/src/assets/indexChart/work.png",
              "业务岗":"/src/assets/indexChart/service.png"}

@eventConnect
class MiddleTable extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 3
    };
    this.state = {
      headerData: {},
      dataList: [],
      total: 0,//总页数
      time: ['08:30-20:30','20:30-次日08:30'],
      selectTime: '08:30-20:30',
    };
  }

  componentDidMount() {
    this.refreshDataList();
    this.getHeaderData();
  }
  getHeaderData = () => {
    middleHeaderAction().then(data => {
      if(data!=null){
        this.setState({ headerData: data })
      }
    });
  }

  refreshDataList = () => {
    middleTabletAction(this.pageConfig.current,this.pageConfig.pageSize).then(data => {
      this.setState({ dataList: data.content, total:data.total })
    });
  }


  leftClick = () => {
    if( this.pageConfig.current != 1 ){
      this.pageConfig.current = this.pageConfig.current == 1 ? 1 : this.pageConfig.current - 1;
      this.refreshDataList();
      this.changeTime();
    }
  }

  rightClick = () => {
    const { total } = this.state;
    let maxNum = Math.ceil( total/this.pageConfig.pageSize );
    if( this.pageConfig.current < maxNum){
      this.pageConfig.current = this.pageConfig.current + 1;
      this.refreshDataList();
      this.changeTime();
    }
  }

  changeTime = () => {
    const { selectTime, time } = this.state;
    let newTime = time.filter( e => {
      return e!=selectTime
    })
    this.setState({ selectTime:newTime[0] })
  }

  render() {
    const { headerData, dataList, time, selectTime } = this.state;
    let leader = headerData.leader || {};
    let second = headerData.second || [];
    return (
        <div className='table-middle'>
          <div className='leaderBox'>
            <div className='leader'>
              <span className='itemLabel'>带班领导</span>
              <span className='itemValue'>{leader.name || ''}{ leader.phone || ''}</span>
            </div>
            <div className='secondLine'>
              <span className='itemLabel'>二线人员</span>
              <div className='itemList'>
                { second && second.map(e => {
                  return (<div key={e.name + e.phone}>
                    <img src={ imgs[e.post] }/><span style={{color:'#05ddf9'}}>{e.post}</span>&emsp;&emsp;
                    {e.name} &emsp; { e.phone }
                  </div>)
                }) }
              </div>
            </div>
          </div>
          {/**<Row className='table-header'>
            <Col className='table-header-left'>
              <Row className='table-header-row'>带班领导</Row>
              <Row className='table-header-row'>{ leader.name || '' }</Row>
              <Row className='table-header-row'>{ leader.phone || ''}</Row>
            </Col>
            <Col className='table-header-right'>
              <Row className='table-header-row'>二线人员</Row>
              { second && second.map(e => {
                return (<Row className='table-header-row' key={e}>
                          <img src={ imgs[e.post] }/><span style={{color:'#05ddf9'}}>{e.post}</span>&emsp;&emsp;
                          {e.name} &emsp;&emsp;&emsp; { e.phone }
                        </Row>)
              }) }
            </Col>
          </Row>*/}
          <Row className='table-header-split'>一线人员</Row>
          <Row className='table-body-cotent firstPeople'>
            <Col className=''>
              <Row className='table-header-row title'>
                <Col className='leftBtn' span={1}><img className='table-page-img' src="/src/assets/3dview/left.png" onClick={ () => this.leftClick() }/></Col>
                <Col span={7}>岗位</Col>
                <Col span={8}>{ selectTime }</Col>
                <Col span={7}>电话</Col>
                <Col className='rightBtn' span={1}><img className='table-page-img' src="/src/assets/3dview/right.png" onClick={ () => this.rightClick() }/></Col>
              </Row>
              { dataList && dataList.map((d,index) => {
                return (
                  <Row className='table-header-row content' key={index}>
                    <Col span={8}>{ d.post }</Col>
                    <Col span={8}>{ d.name }</Col>
                    <Col span={8}>{ d.phone }</Col>
                  </Row>
                )
              }) }

            </Col>

          </Row>
        </div>
    );

  }
}

MiddleTable.propTypes = {
  subscribe: PropTypes.func,
  trigger: PropTypes.func
};

export default MiddleTable;
