import React, { Component } from 'react';
import PropTypes from 'prop-types';

/**
 * 闪烁Div
 *
 * @class TwinkleDiv
 * @extends {Component}
 */
class TwinkleDiv extends Component {
  constructor(props) {
    super(props);
  }

  render() {
    const { eName, aName, status, isCenter } = this.props.info;
    const { markerOnClick, styleCss } = this.props;
    let color;
    let visable = false;
    if (status && status === 1){
      color = '#f50000';
      visable = true;
    } else {
      color = isCenter === 1 ? '#004CFF' : '#FF7700';
    }
    const style = {
      backgroundColor: color
    };


    return (
      <div className={eName} style={style} >
        <span onClick={() => markerOnClick(eName)}>{aName}</span>
        <div className={`${eName}-line`} style={style} />
        { visable && (eName === 'xian' || eName === 'xianyang') && <div className={`${eName} pulse-spread-circular`} /> }
        { visable && <div className={`${eName} pulse-spread-div`} onClick={() => markerOnClick(eName)} /> }
      </div>
    );
  }
}

TwinkleDiv.propTypes = {
  markerOnClick: PropTypes.func
};

export default TwinkleDiv;
