import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Icon, Row, Col } from 'amos-framework';
import DetailCard from './DetailCard';
import { baseURI } from 'CONSTS/urlConsts';
class CarDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      car: {}
    };
  }

  componentWillMount = () => {
    this.setState({ car: this.props.car });
  }


  componentWillReceiveProps = (nextProps) => {
    this.setState({ car: nextProps.car });
  }

  getCarDetailComponent = () => {
    const { car = {} } = this.state;
    let model = '';

    model = `${car.country || ''}-${car.model || ''}`;
    if (model.startsWith('-')) {
      model = model.substr(1, model.length);
    }

    let property = null;
    if (car && car.performanceIndex) {
      property = JSON.parse(car.performanceIndex);
    }
    return (
      <div>
        <DetailCard title="车辆图片" >
          <img className="preControl-car-img-size" src={baseURI+`/${car.photoPath}` || ''} />
        </DetailCard>
        <DetailCard title="主要参数" >
          <div className="mainParam">
            <Row>
              <Col span={8}>车牌：</Col>
              <Col span={16}>
                {car.carNum}
              </Col>
            </Row>
            <Row>
              <Col span={8}>车辆类型：</Col>
              <Col span={16}>
                {car.type}
              </Col>
            </Row>
            <Row>
              <Col span={8}>车辆型号：</Col>
              <Col span={16}>
                {model}
              </Col>
            </Row>
            <Row>
              <Col span={10}>发动机型号：</Col>
              <Col span={14}>
                {car.engineNum}
              </Col>
            </Row>
            <Row >
              <Col span={24} className="replenish">{car.remark}</Col>
            </Row>
          </div>
        </DetailCard>
        <DetailCard title="性能指标" >
          <div className="mainParam">
            {this.getPropertyComponent(property)}
          </div>
        </DetailCard>
      </div>
    );
  }

  getPropertyComponent = (arr) => {
    if (!arr) {
      return;
    }
    return arr.map(data => {
      return (
        <Row key={data.orderNo}>
          <Col span={10}>{data.name}</Col>
          <Col span={14}>
            {data.value}
          </Col>
        </Row>
      );
    });
  }


  render() {
    const { car = {} } = this.state;
    return (
      <div className="precontrol-detail-equip">
        <div className="carHead">
          <div className="carImg"></div>
          <div className="precontrol-basic-info">
            <div className="carBasic">
              <span className="carName">{car.name}</span>
              <div className="post" >
                {car.state}
              </div>
            </div>
            <div className="carInfo">
              <Row>
                <Col span={8}>责任部门：</Col>
                <Col span={16}>
                  消防安全部
                </Col>
              </Row>
              <Row>
                <Col span={8}>车长：</Col>
                <Col span={16}>
                  王多余
                </Col>
              </Row>
              <Row>
                <Col span={8}>电话：</Col>
                <Col span={16}>
                  13802942364
                </Col>
              </Row>
            </div>
          </div>
        </div>
        <div className="carContext">
          {this.getCarDetailComponent()}
        </div>
      </div>
    );
  }
}

CarDetail.propTypes = {
  car: PropTypes.object
};

export default CarDetail;
