import React, { Component } from 'react';
import moment from 'moment';
import { Row, Col } from 'amos-framework';
import { impEquDetail3dAction } from '../../../../../../services/3dService';


/**
 * 服务器网络接口详情
 *
 * @class ServerInterfaceDetail
 * @extends {Component}
 */
class ServerInterfaceDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {}
    };
  }

  componentDidMount(){
    const { equimentId } = this.props;
    // equimentId && this.queryImpEquDetail3d(equimentId);
  }

//   queryImpEquDetail3d =(equimentId)=>{
//     impEquDetail3dAction(equimentId).then(data =>{
//       this.setState({ data });
//     });
//   }

  render() {
    const { data = {} } = this.props;
    return (
        <div className='impEqu-server-interface'>
            <div className='server-interface-header'>
                <Row>
                    <Col className='interface-header-col'><div className='server-title'>{data.networkAdapter || '' }</div></Col>
                </Row>
                <Row>
                    <Col className='interface-header-col'>
                        <div className='interface-header-comp'>
                            <span className='header-comp-span'>IBM USB远程</span>
                            <div className="interface-horizontal-line"/>
                            <img className="interface-img" src='/src/assets/3dview/severInterfaceComp.png'/>
                            <div className="interface-horizontal-line"/>
                            <span className='header-comp-span'>NDIS 网络设备</span>
                         </div>
                    </Col>
                </Row>
                <Row>
                    <Col className='interface-header-col'>
                        <div className='interface-header-comp' style={{paddingRight: '60px'}}>
                            <span className='header-byte-span'><b>字节：</b> { data.send } </span> 
                            <div className="interface-vertical-line"/> 
                            <span className='header-byte-span'>{ data.receive }</span>
                        </div>
                    </Col>
                </Row>
            </div>
            <Row className="impEqu-interface-row" >
                <Col span={6} className="colTitle"> 进速率：</Col>
                <Col span={6} className="colValue">{data.inRate || '' }</Col>
                <Col span={6} className="colTitle">  出速率：</Col>
                <Col span={6} className="colValue">{data.outRate || '' }</Col>
            </Row>
            <Row className="impEqu-interface-row" >
                <Col span={6} className="colTitle"> 进带宽利用率：</Col>
                <Col span={6} className="colValue">{data.inBandwidthUtilization || '' }</Col>
                <Col span={6} className="colTitle">  出带宽利用率：</Col>
                <Col span={6} className="colValue">{data.outBandwidthUtilization || '' }</Col>
            </Row>
            <Row className="impEqu-interface-row" >
                <Col span={6} className="colTitle"> 总带宽利用率：</Col>
                <Col span={6} className="colValue">{data.bandwidthUtilization || '' }</Col>
            </Row>
            <Row className="impEqu-interface-row" >
                <Col span={6} className="colTitle"> 进丢包率：</Col>
                <Col span={6} className="colValue">{data.inLossRate || '' }</Col>
                <Col span={6} className="colTitle">  出丢包率：</Col>
                <Col span={6} className="colValue">{data.outLossRate || '' }</Col>
            </Row>
            <Row className="impEqu-interface-row" >
                <Col span={6} className="colTitle"> 网络带宽：</Col>
                <Col span={6} className="colValue">{data.bandwidth || '' }</Col>
                <Col span={6} className="colTitle">  冲突数：</Col>
                <Col span={6} className="colValue">{data.conflictsNum || '' }</Col>
            </Row>
        </div>
    );
  }
}

ServerInterfaceDetail.propTypes = {

};

export default ServerInterfaceDetail;
