import React, { Component } from 'react';
import moment from 'moment';
import { Row, Col } from 'amos-framework';
import { impEquDetail3dAction } from '../../../../../../services/3dService';

const bodtCxt = [
    { name: '端口号',key: 'port' },
    { name: '类型',key: 'type' },
    { name: '端口别名',key: 'portAlias' },
    { name: '端口从属VLAN',key: 'VLAN' },
    { name: '端口宽带',key: 'portBandwidth' },
    { name: '管理状态',key: 'manageStatus', renderStatusImg: true },
    { name: '运行状态',key: 'status', renderStatusImg: true },
    { name: '进流量',key: 'inFlow' },
    { name: '出流量',key: 'outFlow' }
  ];
const getStatusImg = (status)=>{
    return status?<img src = '/src/assets/3dview/controlStatus2.png'/>:<img src = '/src/assets/3dview/controlStatus1.png'/>
};
/**
 * 端口浮窗详情
 *
 * @class portDeatilModel
 * @extends {Component}
 */
class portDeatilModel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {port:'GigabitEthernet4/0/30',
            type:'以太网端口',
            portAlias:'GigabitEthernet4/0/30',
            VLAN:'-',
            portBandwidth:'100.0Mbps',
            manageStatus:false,
            status:true,
            inFlow:'0.00bps',
            outFlow:'0.00bps'
            }
    };
  }

  componentDidMount(){
  }
  render() {
    const { x, y , detailShow } = this.props;
    const { data } = this.state;
    console.log(x, y , detailShow);
    return (
        <div className='impEqu-detail-model' style={{top: y, left: x, display: detailShow}}>
            {bodtCxt.map(item=>{
            return (<Row  className='impEqu-detail-modal-row' key={item.key} >
                        <Col className="colTitle">{item.name}：</Col>
                        <Col className="colValue">{item.renderStatusImg ? getStatusImg(data[item.key]) : data[item.key]}</Col>
                    </Row>);
            })}
        </div>
    );
  }
}

portDeatilModel.propTypes = {

};

export default portDeatilModel;
