import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Markers } from 'amos-3d';
import { CONSTS } from 'CONSTS/storageConsts';
import PointDialog from './PointDialog';
import MarkerIcon from './MarkerIcon';
import StatisticsMarkerIcon from './markers/StatisticsMarkerIcon';
import { tirggerTransTopic, tirggerPlanTopic } from '../dataProcessor';

export default function markerFactory(WrappedComponent = 'div', options){
  const { markerType } = options;
  class MarkerPoints extends Component {
    static propTypes = {
      visible: PropTypes.bool,// marker 显式隐藏
      planStarted: PropTypes.bool
    };

    constructor(props) {
      super(props);
      this.markerEvents = {
        click: this.onMarkerClick,
        dblclick: this.onMarkerDblClick
      };
    }

    componentWillMount = () => {
      this.setState({ planStarted: this.props.planStarted });
    }

    componentWillReceiveProps = nextProps => {
      this.setState({ planStarted: nextProps.planStarted });
    }

    /**
     * 标记的点单击事件
     *
     * @memberof MarkerPoints
     */
    onMarkerClick = (marker, e) => {
      clearTimeout(this.time);
      tirggerPlanTopic(CONSTS.plan_detail, { type: marker.extData.type, data: marker.extData });
      // if (marker.extData.markerType === 'impEquipment' && void 0 !== marker.extData.show) {
      //   tirggerTransTopic(CONSTS.forward, { details: { type: 'impEquipment',  dialogId: marker.extData.equipmentId, show: marker.extData.show }, dateTime: Date.now() });
      //   return;
      // }
      if (marker.extData.markerType === 'impEquipment' && void 0 !== marker.extData.show) {
        this.time = setTimeout(() => this.pdRef && this.pdRef.onOpenClick(marker), 500);
      }
    }

    /**
     * 标记的点双击事件
     *
     * @memberof MarkerPoints
     */
    onMarkerDblClick = (marker, e) => {
      clearTimeout(this.time);
      tirggerPlanTopic(CONSTS.plan_detail, { type: marker.extData.type, data: marker.extData });
      // if (marker.extData.markerType === 'impEquipment' && void 0 !== marker.extData.show) {
      //   tirggerTransTopic(CONSTS.forward, { details: { type: 'impEquipment',  dialogId: marker.extData.equipmentId, show: marker.extData.show }, dateTime: Date.now() });
      //   return;
      // }
      this.time = setTimeout(() => this.pdRef && this.pdRef.onOpenClick(marker), 500);
      // this.pdRef.tirggerBussines(marker);
    }

    /**
     * 鼠标移入事件
     *
     * @memberof MarkerPoints
     */
    renderMarkerHover = (extData) => {
      return <MarkerIcon {...extData} markerType={markerType} />;
    }

    /**
     * 渲染点标记
     *
     * @memberof MarkerPoints
     */
    renderMarker = (extData) => {

      // console.log(extData);

      if (markerType === 'statistics') {
        return <StatisticsMarkerIcon statistics={extData} />;
      } else {
        return <MarkerIcon {...extData} markerType={markerType} />;
      }
    }

    render() {
      const { planStarted } = this.state;
      let dialogStyle = { zIndex: 1000 };
      return (
        <WrappedComponent>
          <Markers
            {...this.props}
            events={this.markerEvents}
            render={this.renderMarker}
          />
          {!planStarted && <PointDialog style={dialogStyle} ref={node => this.pdRef = node} />}
        </WrappedComponent>
      );
    }
  }

  return MarkerPoints;
}
