import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Modal } from 'amos-framework';
import { CONSTS } from 'CONSTS/storageConsts';
import { eventTopics } from '../../consts';
import { tirggerTransTopic } from '../../dataProcessor';

const eventConnect = Connect.eventConnect;
const closeImgPath = require('./../../../../../assets/3dview/prePlan/dingbu-tuichu.png');

/**
 * 顶部展示
 *
 * @class TopView
 * @extends {Component}
 */
@eventConnect
class TopView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      // eslint-disable-next-line react/prop-types
      showContent: this.props.planStarted === true ? '' : 'none',
      content: '',
      timeCount: 0
    };
    this.timer = null;
  }

  componentDidMount() {
    this.props.subscribe(eventTopics.top_ae_msg, (topic, data) => {
      const { content }  = data.content;
      this.props.planStart(data.content);
      this.setState( { content, showContent: 'block' } );
      let { planStart } = this.props;
      this.prepareChangeTimeText(planStart);
    });
  }

  componentWillReceiveProps(nextProps) {
    if (!this.timer && nextProps.planStart) {
      this.prepareChangeTimeText(nextProps.planStart);
    }
  }

  componentWillUnmount() {
    clearTimeout(this.timer);
  }

  quit = (_this) => {
    Modal.confirm({
      content: '确认退出应急预案？',
      onOk() {
        // 执行删除逻辑
        tirggerTransTopic(CONSTS.forward, { details: { type: 'prePlan', show: false } });
        _this.props.planQuit();
      },
      onCancel() {}
    });
  }

  prepareChangeTimeText = (planStart) => {
    clearInterval(this.timer);
    this.timer = setInterval(() => {
      this.changeTimeText();
    }, 1000);
  }

  changeTimeText = () => {
    let { timeCount } = this.state;
    timeCount += 1;
    let formatTime = this.formatTime(timeCount);
    let targetEle = document.getElementById('time-text');
    targetEle && (targetEle.innerHTML = formatTime);
    this.setState({ timeCount });
  };

  formatTime = timeCount => {
    let secord = parseInt(timeCount); // 秒
    let minute = 0; // 分
    let hour = 0; // 小时

    if (secord >= 59) {
      minute = parseInt(secord / 60);
      secord = parseInt(secord % 60);
      if (minute >= 59) {
        hour = parseInt(minute / 60);
        minute = parseInt(minute % 60);
      }
    }
    let result = '' + parseInt(hour) + '小时' + parseInt(minute) + '分' + parseInt(secord) + '秒）';
    return result;
  };

  render() {
    const { content }  = this.state;
    return (
      <div className="precontrol-top-view" >
        <div className="top-view-1" style={{ display: this.state.showContent }}>
          <div className="quit-btn" onClick={() => this.quit(this)}>
            <img src={closeImgPath} alt="" />
          </div>
          <div className="text-content-eq">
            {content}
            <span>（持续时间：</span>
            <span id="time-text" />
          </div>
        </div>
      </div>
    );
  }
}

TopView.propTypes = {
  subscribe: PropTypes.func,
  planStart: PropTypes.func,
  planQuit: PropTypes.fucn
};

export default TopView;
