import React, { Component } from 'react';
import PropTypes from 'prop-types';
import StepCxtLine from './StepCxtLine';

/**
 *
 * 体部分
 * @class StepCxtBody
 * @extends {Component}
 */
class StepCxtBody extends Component {
  constructor(props) {
    super(props);

  }

  /**
   * 获取步骤体
   *
   * @memberof StepCxtBody
   */
  getStepBody =(buttonList)=>{
    const { onButtonClick } = this.props;
    return buttonList.map(e=>{
      return <StepCxtLine key={e.id} message={e} onButtonClick={onButtonClick} />;
    });
  }

  render() {
    const { buttonList = [] } = this.props;
    return (
      <div className='step-cxt-body-root'>
        {this.getStepBody(buttonList)}
      </div>
    );
  }
}

StepCxtBody.propTypes = {
  onButtonClick: PropTypes.func,
  buttonList: PropTypes.array
};

export default StepCxtBody;
