import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { message } from 'amos-framework';
import AmosWebSocket from 'amos-websocket';
import TopologyComponent from './TopologyComponent';
import TreeComponent from './TreeComponent';
import { getDyTopoAction,updateDyTopoAction } from './../../../services/dynamicRingService';
import SysWsURL from './../../../consts/wsUrlConsts';


class DynamicRing extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedKeys: [],
      wSelectedKeys: '',
      topologyData: {} //拓扑图数据
    };
  }

  // 拓扑图数据初始化
  initTopologyData = (id,value = '') => {
    getDyTopoAction(id).then(data => {
      if (value === 'refresh') {
        message.success('拓扑图刷新成功!');
      }
      this.setState({
        topologyData: data
      });
    });
  }

  // 树选择
  onSelect = (selectedKeys) => {
    this.initTopologyData(selectedKeys);
    this.setState({
      selectedKeys,
      wSelectedKeys: ''
    });
  }

  // 节点数据改变
  nodeChange = (e) => {
    // console.log(e.model.toJson());
    this.updateTopologyData = JSON.parse(e.model.toJson());
  }

  // 保存节点数据
  saveTopologyData = () => {
    const { selectedKeys } = this.state;
    const { nodeDataArray,linkDataArray } = this.updateTopologyData;
    const params = {
      treeid: selectedKeys,
      nodeData: nodeDataArray,
      linkData: linkDataArray
    };
    updateDyTopoAction(params).then(data => {
      message.success('拓扑图保存成功!');
    });
  }

  // 刷新节点
  refreshTopologyData = () => {
    const { selectedKeys } = this.state;
    this.initTopologyData(selectedKeys, 'refresh');
  }

  // 选择节点
  nodeSelectionChanged = (e) => {
    // console.log('e',e);
    if (e.isSelected) { }
  }

  // // webSocket 接收消息
  handleData = (data) => {
    this.onSelect(data);
    this.setState({
      wSelectedKeys: data
    });
  }

  render() {
    const { topologyData,wSelectedKeys } = this.state;
    return (
      <div className="dy-wrapper">
        <AmosWebSocket
          ref={node => this.aws = node}
          url={SysWsURL.dyTopoURI}
          onMessage={this.handleData}
          reconnect
          debug
        />
        <div className="left-content">
          <TreeComponent
            onSelect={this.onSelect}
            wSelectedKeys={wSelectedKeys}
          />
        </div>
        <div className="right-content">
          <div className="net-topo-header">
            <div className="net-topo-save">
              <img src="/src/assets/bizView/netTopology/save.png" alt="保存"  onClick={this.saveTopologyData} />
            </div>
            <div className="net-topo-refresh">
              <img src="/src/assets/bizView/netTopology/refresh.png" alt="刷新"  onClick={this.refreshTopologyData} />
            </div>
          </div>
          <div className="net-topo-content">
            <TopologyComponent
              topologyData={topologyData}
              nodeChange={this.nodeChange}
              nodeSelectionChanged={this.nodeSelectionChanged}
            />
          </div>
        </div>
      </div>
    );
  }
}

DynamicRing.propTypes = {

};

export default DynamicRing;
