
import React, { Component } from 'react';
import { Marker } from 'amos-amap';

class CarMaker extends Component {


    constructor(props) {
        super(props);
        this.state = {
            center: {},
            path: []
        };
        this.markerEvents = {
            created: (instance) => {
                console.log(instance);
            }
        };   

    }
    componentWillMount() {
        const center = this.props.path[0];
        const path = this.props.path;
        this.setState({
            center,
            path
        })
    }


    render() {
        const { center } = this.state;
        const styleA = {
            background: `url('/src/assets/3dview/u348.png')`,
            backgroundSize: 'contain',
            backgroundRepeat: 'no-repeat',
            backgroundPosition: 'center',
            width: '40px',
            height: '40px',
            color: '#000',
            textAlign: 'center',
            lineHeight: '40px',
            borderRadius: '20px'
        }

        return <div>
            <Marker position={center} >
                <div style={styleA}></div>
            </Marker>
        </div>
    }

}

export default CarMaker
