import React, { Component } from 'react';
import { UUID } from 'amos-tool';
import { Tabs } from 'amos-framework';
import PortTable from './portTable';
import AlertTable from './alertTable';
import RouterTable from './routerTable';
import ForwardTable from './forwardTable';
import ARPTable from './ARPTable';


const { TabList, Tab, TabPanel } = Tabs;
class FirewallTab extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }


  render() {
    return (
      <div className="pams-class" style={{ position: 'absolute',zIndex: '999' }}>
        <Tabs>
          <TabList>
            <Tab>端口</Tab>
            <Tab>路由表</Tab>
            <Tab>转发表</Tab>
            <Tab>ARP</Tab>
            <Tab>产生的告警</Tab>
          </TabList>
          <TabPanel><PortTable key={UUID.uuid('16')} /></TabPanel>
          <TabPanel><RouterTable key={UUID.uuid('16')} /></TabPanel>
          <TabPanel><ForwardTable key={UUID.uuid('16')} /></TabPanel>
          <TabPanel><ARPTable key={UUID.uuid('16')} /></TabPanel>
          <TabPanel><AlertTable key={UUID.uuid('16')} /></TabPanel>

        </Tabs>
      </div>
    );
  }
}

export default FirewallTab;
