import React, { Component } from 'react';
import { Table } from 'amos-antd';
import { getRouterList } from './../../../../services/pamsTableService';

class RouterTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      totalPage: 0,
      total: 0,
      current: 1,
      pageSize: 5,
      routerList: []
    };
  }


  componentDidMount() {
    this.querryData();
  }

  /**
   * 获取端口数据
   */
  querryData() {
    getRouterList('/src/_mock/pamsTable/index.json', routerList => {
      this.setState({ routerList });
    });
  }

  /**
   *
   *设置共多少页
   */
  showTotal = (total) => {
    return `共 ${( total % this.state.pageSize) ===0 ? Math.floor((total / this.state.pageSize)) : Math.floor((( total / this.state.pageSize) + 1))} 页`;
  }

  /**
   * 设置当前页事件
   */
  onPaginationChange = (current) => {
    this.setState({ current },this.reload);
  }

  rendColumns = () => {
    return [
      {
        title: '序号',
        dataIndex: 'rownum',
        key: 'rownum',
        width: '2%'
      },
      {
        title: '端口索引',
        dataIndex: 'portIndex',
        key: 'portIndex',
        width: '5%'
      },
      {
        title: '鼠标IP',
        dataIndex: 'mouseIP',
        key: 'mouseIP',
        width: '5%'
      },
      {
        title: '掩码',
        dataIndex: 'mask',
        key: 'mask',
        width: '5%'
      },
      {
        title: '类型',
        dataIndex: 'type',
        key: 'type',
        width: '5%'
      },
      {
        title: '下一跳IP',
        dataIndex: 'nextStationIP',
        key: 'nextStationIP',
        width: '5%'
      }
    ];
  };

  render() {
    const { routerList } = this.state;
    let tepmPage = Object.assign({
      size: 'small',
      total: this.state.totals,
      current: this.state.current,
      pageSize: this.state.pageSize,
      //onShowSizeChange: this.onSizeChange,
      onChange: this.onPaginationChange,
      showSizeChanger: 'true',
      pageSizeOptions: [5],
      showTotal: this.showTotal
    },  false);
    return (
      <div style={{width: '58%',height: '100%',marginLeft: '28px'}}>
        <Table
          pagination={tepmPage}
          columns={this.rendColumns()}
          dataSource={routerList} />
      </div>
    );
  }
}

export default RouterTable;
