import React, { Component } from 'react';
import { Table } from 'amos-antd';
import { getSurroundingsList } from './../../../../services/pamsTableService';

class SurroundingsTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      totalPage: 0,
      total: 0,
      current: 1,
      pageSize: 5,
      surroundingsList: []
    };
  }

  /**
   *
   *设置共多少页
   */
  showTotal = (total) => {
    return `共 ${( total % this.state.pageSize) ===0 ? Math.floor((total / this.state.pageSize)) : Math.floor((( total / this.state.pageSize) + 1))} 页`;
  }

  /**
   * 设置当前页事件
   */
  onPaginationChange = (current) => {
    this.setState({ current },this.reload);
  }

  componentDidMount(){
    this.qurrySurroundingsLis();
  }


/**
 *获取数据
 *
 */
qurrySurroundingsLis(){
  debugger;
  getSurroundingsList('/src/_mock/pamsTable/index.json',(surroundingsList)=>{
    console.log('获取 surroundingsList',surroundingsList);
    this.setState({surroundingsList });
  });
}

rendColumns = () => {
    return [
      {
        title: '框架序号',
        dataIndex: 'rownum',
        key: 'rownum',
        width: '2%'
      },
      {
        title: '槽道序号',
        dataIndex: 'channelNum',
        key: 'channelNum',
        width: '5%'
      },
      {
        title: '类型',
        dataIndex: 'type',
        key: 'status',
        width: '5%'
      },
      {
        title: '状态',
        dataIndex: 'status',
        key: 'status',
        width: '5%'
      },
      {
        title: '当前值',
        dataIndex: 'currentValue',
        key: 'currentValue',
        width: '5%'
      },
      {
        title: '允许最高值',
        dataIndex: 'MaxValue',
        key: 'MaxValue',
        width: '5%'
      },
      {
        title: '允许最低值',
        dataIndex: 'minValue',
        key: 'minValue',
        width: '5%'
      }
    ];
  };

  render() {
    const {surroundingsList } = this.state;
    let tepmPage = Object.assign({
      size: 'small',
      total: this.state.totals,
      current: this.state.current,
      pageSize: this.state.pageSize,
      //onShowSizeChange: this.onSizeChange,
      onChange: this.onPaginationChange,
      showSizeChanger: 'true',
      pageSizeOptions: [5],
      showTotal: this.showTotal
    },  false);
    return (
      <div style={{width: '78%',height: '100%',marginLeft: '28px'}}>
        <Table
          pagination={tepmPage}
          columns={this.rendColumns()}
          dataSource={surroundingsList } />
      </div>
    );
  }
}

export default SurroundingsTable;
