import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Input, Select, Radio } from 'amos-framework';
import { stringify } from 'amos-tool';

import { getFireStationDetailAction } from '../../../../../services/ledgerService';

const FormItem = Form.Item;
const RadioGroup  = Radio.Group;
const Option = Select.Option;
const floorData = [{id:'1',name:'1层'},{id:'2',name:'2层'},{id:'3',name:'3层'},{id:'4',name:'4层'},{id:'5',name:'5层'}];

class FireStationDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      station: {
        name:'',
        code:'',
        address:'',
        position3d:'',
        floor3d:'',
        isIndoor: true
      }
    };
  }
  componentDidMount() {
    this.queryFireStationDetail();
  }

  queryFireStationDetail = () => {
    let { stationId } = this.props;
    getFireStationDetailAction( stationId ).then(station => {
      this.setState({ station });
    });
  }

  render() {
    const { station } = this.state;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
 
    return (
      <Form  className="basic-demo" model={station} >
        <FormItem label={<span>小室名称</span>} field="name" {...formItemLayout} >
          <Input
            value={station.name ? station.name : ''}
          />
        </FormItem>
        <FormItem label={<span>小室编码</span>} field="code" {...formItemLayout} >
          <Input
            value={station.code ? station.code : ''}
          />
        </FormItem>
        <FormItem label="小室地址" field="address" {...formItemLayout} >
          <Input
            value={station.address ? station.address : ''}
          />
        </FormItem>
        <FormItem label={<span>3维坐标</span>} field="position3d" {...formItemLayout}>
            <Input className="fire-foam-input" value={station.position3d} />
        </FormItem>
        <FormItem label={<span>3维楼层</span>} field="floor3d" {...formItemLayout}>
          <Select
              className="fire-foam-select"
              data={floorData}
              value={station.floor3d}
              renderOption={item => <Option value={item.id}>{item.name}</Option>}
          />
        </FormItem>
        <FormItem label={<span>是否室内</span>} field="isIndoor" {...formItemLayout}>
          <RadioGroup defaultValue={station.isIndoor} value={station.isIndoor}>
            <Radio value= {false}>否</Radio>
            <Radio value= {true}>是</Radio>
          </RadioGroup>
        </FormItem>
      </Form>
    );
  }
}

FireStationDetail.propTypes = {
  stationId: PropTypes.number
};
export default FireStationDetail;
