import React, { Component } from 'react';
import { Form, Input } from 'amos-framework';
import PropTypes from 'prop-types';

const FormItem = Form.Item;

class FireStrengthAdd extends Component {
  constructor(props) {
    super(props);
    this.state = {
      strength: {
        type: 1,
        code: '',
        username: '',
        phone_num: '',
        position: '',
        tel: '',
        jobDes: '',
        remark: ''
      },
      rules: {
        code: [
          { required: true, message: '请输入编号' }
        ],
        username: [
          { required: true, message: '请输入名称' }
        ],
        position: [
          { required: true, message: '请输入职位' }
        ],
        phone_num: [
          { required: true, message: '请输入移动号码' }
        ]
      }
    };
  }

  onChange = (key, e) => {
    const { strength } = this.state;
    const value = e.target.value;
    if (key === 'phoneNum') {
      strength['phone_num'] = value;
    } else {
      strength[key] = value;
    }
    this.setState({ strength });
    this.props.callback(strength);
  }

  render() {
    const { strength, rules } = this.state;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <Form  className="basic-demo" model={strength} rules={rules} ref={component => this.form = component}>
        <FormItem label={<span>名称</span>} field="username" {...formItemLayout} >
          <Input
            value={strength.username ? strength.username : ''}
            onChange={(e) => this.onChange('username', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label={<span>编号</span>} field="code" {...formItemLayout} >
          <Input
            value={strength.code ? strength.code : ''}
            onChange={(e) => this.onChange('code', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label={<span>职位</span>} field="position" {...formItemLayout} >
          <Input
            value={strength.position ? strength.position : ''}
            onChange={(e) => this.onChange('position', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label="固话" field="tel" {...formItemLayout} >
          <Input
            value={strength.tel ? strength.tel : ''}
            onChange={(e) => this.onChange('tel', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label="移动号码" field="phone_num" {...formItemLayout} >
          <Input
            value={strength.phone_num ? strength.phone_num : ''}
            onChange={(e) => this.onChange('phoneNum', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label="工作描述" field="jobDes" {...formItemLayout} >
          <Input
            value={strength.jobDes ? strength.jobDes : ''}
            onChange={(e) => this.onChange('jobDes', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label="备注" field="remark" {...formItemLayout} >
          <Input
            value={strength.remark ? strength.remark : ''}
            onChange={(e) => this.onChange('remark', e)}
            className="risk_factor_input"
          />
        </FormItem>
      </Form>
    );
  }
}

FireStrengthAdd.propTypes = {
  callback: PropTypes.func
};

export default FireStrengthAdd;
