import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Input } from 'amos-framework';
import { stringify } from 'amos-tool';

import { getFireStrengthDataAction } from '../../../../../services/ledgerService';

const FormItem = Form.Item;

class FireStrengthDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      station: {
      }
    };
  }
  componentDidMount() {
    this.queryFireStationDetail();
  }

  queryFireStationDetail = () => {
    let { strengthId } = this.props;
    getFireStrengthDataAction( strengthId ).then(station => {
      this.setState({ station });
    });
  }

  render() {
    const { station } = this.state;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <Form  className="basic-demo" model={station} >
        <FormItem label={<span>名称</span>} field="username" {...formItemLayout} >
          <Input
            value={station.username ? station.username : ''}
            onChange={(e) => this.onChange('username', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label={<span>编码</span>} field="code" {...formItemLayout} >
          <Input
            value={station.code ? station.code : ''}
            onChange={(e) => this.onChange('code', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label={<span>职位</span>} field="position" {...formItemLayout} >
          <Input
            value={station.position ? station.position : ''}
            onChange={(e) => this.onChange('position', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label="固话" field="tel" {...formItemLayout} >
          <Input
            value={station.tel ? station.tel : ''}
            onChange={(e) => this.onChange('tel', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label="移动号码" field="phoneNum" {...formItemLayout} >
          <Input
            value={station.phoneNum ? station.phoneNum : ''}
            onChange={(e) => this.onChange('phoneNum', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label="工作描述" field="jobDes" {...formItemLayout} >
          <Input
            value={station.jobDes ? station.jobDes : ''}
            onChange={(e) => this.onChange('jobDes', e)}
            className="risk_factor_input"
          />
        </FormItem>
        <FormItem label="备注" field="remark" {...formItemLayout} >
          <Input
            value={station.remark ? station.remark : ''}
            onChange={(e) => this.onChange('remark', e)}
            className="risk_factor_input"
          />
        </FormItem>
      </Form>
    );
  }
}

FireStrengthDetail.propTypes = {
  strengthId: PropTypes.number
};
export default FireStrengthDetail;
