import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button, Input } from 'amos-framework';
import BizIcon from './../../../../common/icon/BizIcon';

/**
 * 工具栏
 *
 * @class RiskFactorToolBar
 * @extends {Component}
 */

class FireTruckToolBar extends Component {
  constructor(props) {
    super(props);
    this.state = {
      name: ''
    };
  }

  componentWillMount() {

  }

  onChange = (e, value) => {
    let { getTableListData, pageConfig } = this.props;
    this.setState({ name: value });
    let searchParam = [{ name: e, value }];
    searchParam.pageNumber = pageConfig.pageNumber;
    searchParam.pageSize = pageConfig.pageSize;
    getTableListData(searchParam);
  };

  render() {
    let { name } = this.state;
    return (
      <div className="fire-truck-toolbar">
        <div className="fire-truck-input">
          <span>车辆名称：</span>
          <Input value={name} onChange={e => this.onChange('name', e.target.value)} />
        </div>
        <div className="fire-truck-buttons">
          <Button icon={<BizIcon icon="tianjia" />} transparent onClick={this.props.add} />
          <Button icon={<BizIcon icon="xiugai" />} transparent onClick={this.props.edit} />
          <Button icon={<BizIcon icon="shanchu" />} transparent onClick={this.props.delete} />
        </div>
      </div>
    );
  }
}

FireTruckToolBar.propTypes = {
  add: PropTypes.func,
  edit: PropTypes.func,
  delete: PropTypes.func,
  getTableListData: PropTypes.func,
  pageConfig: PropTypes.object
};

export default FireTruckToolBar;
