import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, InputNumber } from 'amos-framework';

const FormItem = Form.Item;

/**
 * 确认耗材类消防资源数量
 */
class InputNumberView extends Component {
  constructor(props) {
    super(props);

    this.pageConfig = {
      pageNumber: 0,
      pageSize: 10
    },
    this.state = {
      form: {
        number: 1
      }
    };
  }

  onInputChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  };

  render() {
    let { form } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 5 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <div>
        <Form model={form}>
          <FormItem label={<span>数量</span>} field="number" {...formItemLayout} >
            <InputNumber className="risk_factor_input" required value={form.number} onChange={value => this.onInputChange('number', value)} defaultValue={1} min={1} />
          </FormItem>
        </Form>
      </div>
    );
  }
}

InputNumberView.propTypes = {
  fireEquipmentId: PropTypes.number,
  totalCount: PropTypes.number,
  dataList: PropTypes.array,
  getTableListData: PropTypes.func
};
export default InputNumberView;
