import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Input, Select, Radio } from 'amos-framework';
import { stringify } from 'amos-tool';

import { getFireWaterDataAction } from '../../../../../services/ledgerService';

const FormItem = Form.Item;
const RadioGroup  = Radio.Group;
const Option = Select.Option;
const floorData = [{ id: '1', name: '1层' }, { id: '2', name: '2层' }, { id: '3', name: '3层' }, { id: '4', name: '4层' }, { id: '5', name: '5层' }];

class FireWaterEdit extends Component {
  constructor(props) {
    super(props);
    this.state = {
      station: {
        name: '',
        code: '',
        address: '',
        room: '',
        productionArea: '',
        position3d: '',
        floor3d: '1',
        isIndoor: true
      },
      rules: {
        code: [{ required: true, message: '请输入编号' }],
        position3d: [{ validator: this.validPositon3d }],
        floor3d: [{ required: true, message: '请选择3维楼层' }]
      }
    };
  }

  componentWillMount() {
    const { station } = this.state;
    station.type = this.props.type;
    this.setState({ station });
    this.queryFireStationDetail();
  }

  onChange = (key, e) => {
    const { station } = this.state;
    const value = e.target.value;
    station[key] = value;
    this.setState({ station });
    this.props.callback(station);
  };

  onInputChange = (key, value) => {
    const { station } = this.state;
    station[key] = value;
    this.setState({ station });
    this.props.callback(station);
  };

  queryFireStationDetail = () => {
    let { stationId } = this.props;
    getFireWaterDataAction(stationId).then(station => {
      this.setState({ station });
      this.props.callback(station);
    });
  };

  validPositon3d = (rule, value, callback) => {
    let tempArry = value.split(',') || [];
    if ( tempArry && tempArry.length === 3 ){
      const patt = /(^([-]?)[1-9]([0-9]+)?(\.[0-9]+)?$)|(^([-]?)(0){1}$)|(^([-]?)[0-9]\.[0-9]+?$)/;
      let i = 0;
      for (let key of tempArry){
        if (!patt.test(key)){
          i = i + 1;
          callback('非法格式');
          break;
        }
      }
      i === 0 ? callback() : '';
    } else if (!value) {
      callback();
    } else {
      callback('非法格式');
    }
  }

  render() {
    const { station, rules } = this.state;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    let name = station.type === '1' ? '消防栓' : '消防水池';

    return (
      <Form className="basic-demo" model={station} rules={rules} ref={component => this.form = component}>
        <FormItem label={<span>{name}名称</span>} field="name" {...formItemLayout}>
          <Input className="risk_factor_input" value={station.name} onChange={e => this.onChange('name', e)} />
        </FormItem>
        <FormItem label={<span>{name}编码</span>} field="code" {...formItemLayout}>
          <Input className="risk_factor_input" value={station.code} onChange={e => this.onChange('code', e)} />
        </FormItem>
        <FormItem label="地址" field="address" {...formItemLayout}>
          <Input className="risk_factor_input" value={station.address} onChange={e => this.onChange('address', e)} />
        </FormItem>
        <FormItem label="区域" field="productionArea" {...formItemLayout}>
          <Input className="risk_factor_input" value={station.productionArea} onChange={e => this.onChange('productionArea', e)} />
        </FormItem>
        <FormItem label="房间" field="room" {...formItemLayout}>
          <Input className="risk_factor_input" value={station.room} onChange={e => this.onChange('room', e)} />
        </FormItem>
        <FormItem label={<span>3维坐标</span>} field="position3d" {...formItemLayout}>
          <Input className="risk_factor_input" value={station.position3d} onChange={e => this.onInputChange('position3d', e.target.value)} />
        </FormItem>
        <FormItem label={<span>3维楼层</span>} field="floor3d" {...formItemLayout}>
          <Select
            className="fire-equip-select"
            data={floorData}
            defaultValue='1'
            value={station.floor3d}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            onChange={e => this.onInputChange('floor3d', e)}
          />
        </FormItem>
        <FormItem label={<span>是否室内</span>} field="isIndoor" {...formItemLayout}>
          <RadioGroup defaultValue={station.isIndoor} value={station.isIndoor} onChange={e => this.onInputChange('isIndoor', e)}>
            <Radio value={false}>否</Radio>
            <Radio value={true}>是</Radio>
          </RadioGroup>
        </FormItem>
      </Form>
    );
  }
}

FireWaterEdit.propTypes = {
  stationId: PropTypes.number,
  callback: PropTypes.func,
  type: PropTypes.number
};
export default FireWaterEdit;
