import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { TreeSelect } from 'amos-antd';
import { Input, Form, Button, Select } from 'amos-framework';
import { getDepatUserListAction } from './../../../../../services/bizService';

const FormItem = Form.Item;
const Option = Select.Option;

/**
 *
 * 设备设施危险因素查询
 * @class EquipRiskFactorListSearch
 * @extends {Component}
 */
class EquipRiskFactorListSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        riskType: {
          name: 'riskType',
          type: 'EQUAL',
          value: ''
        },
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        riskSourceName: {
          name: 'riskSourceName',
          type: 'LIKE',
          value: ''
        },
        equipmentCode: {
          name: 'equipmentCode',
          type: 'LIKE',
          value: ''
        },
        controlObjectName: {
          name: 'controlObjectName',
          type: 'LIKE',
          value: ''
        },
        regionId: {
          name: 'regionId',
          type: 'EQUAL',
          value: ''
        },
        equipmentDepartmentId: {
          name: 'equipmentDepartmentId',
          type: 'EQUAL',
          value: ''
        },
        workshopSection: {
          name: 'workshopSection',
          type: 'LIKE',
          value: ''
        },
        levelId: {
          name: 'levelId',
          type: 'EQUAL',
          value: ''
        },
        identificationMethodIds: {
          name: 'identificationMethodIds',
          type: 'LIKE',
          value: ''
        },
        userIds: {
          name: 'userIds',
          type: 'LIKE',
          value: ''
        },
        firstEvaluateUserName: {
          name: 'firstEvaluateUserName',
          type: 'LIKE',
          value: ''
        },
        secondEvaluateUserName: {
          name: 'secondEvaluateUserName',
          type: 'EQUAL',
          value: ''
        }
      },
      deptData: [],
      areaData: [],
      levelData: [],
      riskTypeData: []
    };
  }

  componentWillMount() {

  }

  componentDidMount() {
  }

  onInputChange = (key, value) => {
    const { form } = this.state;
    if (key === 'regionId') {
      this.getDeptData(value);
      form.equipmentDepartmentId.value = '';
    }
    form[key].value = value;
    this.setState({ form });
  }

  onClick =()=>{
    const { form } = this.state;
    this.props.search(form);
  }

  onSelectChange = (key, value, t, obj) => {
    const { form } = this.state;
    if (obj && obj.triggerNode && obj.triggerNode.props && obj.triggerNode.props.type === 'department') {
      return;
    }
    if (obj && obj.triggerNode && obj.triggerNode.props && obj.triggerNode.props.type === 'model') {
      return;
    }
    form[key].value = value;
    this.setState({ form });
  };

  getDeptData = (regionId) => {
    let { deptData } = this.state;
    const { searchCommonData } = this.props;
    let depatData = searchCommonData.regionDepartmentTree && searchCommonData.regionDepartmentTree.secondDepartments;
    let dData  = new Map(Object.entries(depatData)).get(String(regionId));
    deptData = [];
    dData && dData.map(item => {
      let deptObj = {};
      deptObj.id = item.sequenceNbr;
      deptObj.name = item.departmentName;
      deptData.push(deptObj);
    });
    this.setState({ deptData });
  };

  initFormValues =()=>{
    const { form } = this.state;
    for (let key in form) {
      form[key].value = '';
    }
    this.setState({ form });
  }

  render() {
    let { form, deptData, riskTypeData, levelData, areaData } = this.state;
    const { searchCommonData } = this.props;
    let { riskLevelData, regionData } = searchCommonData || {};
    levelData = riskLevelData;
    areaData = regionData;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 10 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 12 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 10 }
      }
    };
    return (
      <Form className="risk-list-search" model={form}>
        <FormItem label={<span>风险类型</span>} field="riskType" {...formItemLayout}>
          <Select
            className="risk-list-select"
            data={riskTypeData}
            renderOption={item => <Option value={parseInt(item.id)}>{item.name}</Option>}
            value={form.riskType.value}
            onChange={value => this.onInputChange('riskType', value)}
          />
        </FormItem>
        <FormItem label={<span>危险有害因素名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} className="risk-list-input" onChange={e => this.onInputChange('name', e.target.value)} />
        </FormItem>
        <FormItem label={<span>危险源名称</span>} field="riskSourceName" {...formItemLayout}>
          <Input value={form.riskSourceName.value} className="risk-list-input" onChange={e => this.onInputChange('riskSourceName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>设备位号</span>} field="equipmentCode" {...formItemLayout}>
          <Input value={form.equipmentCode.value} className="risk-list-input" onChange={e => this.onInputChange('equipmentCode', e.target.value)} />
        </FormItem>
        <FormItem label={<span>设备名称</span>} field="controlObjectName" {...formItemLayout}>
          <Input value={form.controlObjectName.value} className="risk-list-input" onChange={e => this.onInputChange('controlObjectName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>所在分区</span>} field="regionId" {...formItemLayout}>
          <Select
            className="risk-list-select"
            data={areaData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.regionId.value}
            onChange={value => this.onInputChange('regionId', value)}
          />
        </FormItem>
        <FormItem label={<span>部门/车间</span>} field="equipmentDepartmentId" {...formItemLayout}>
          <Select
            className="risk-list-select"
            data={deptData}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.equipmentDepartmentId.value}
            onChange={value => this.onInputChange('equipmentDepartmentId', value)}
          />
        </FormItem>
        <FormItem label={<span>所属工段</span>} field="workshopSection" {...formItemLayout}>
          <Input value={form.workshopSection.value} className="risk-list-input" onChange={e => this.onInputChange('workshopSection', e.target.value)} />
        </FormItem>
        <FormItem label={<span>风险等级</span>} field="levelId" {...formItemLayout}>
          {/*<Select
            className="risk-list-select"
            data={levelData}
            renderOption={item => <Option value={parseInt(item.id)}>{item.name}</Option>}
            value={form.levelId.value}
            onChange={value => this.onInputChange('levelId', value)}
          />*/}
          <TreeSelect
            value={form.levelId.value === 0 ? undefined : form.levelId.value}
            className="risk-list-select"
            dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
            treeData={levelData || []}
            placeholder="请选择"
            allowClear
            showSearch
            treeNodeFilterProp={'title'}
            treeDefaultExpandAll
            onChange={(e, t, obj) => this.onSelectChange('levelId', e, t, obj)}
          />
        </FormItem>
        <FormItem label={<span>辨识方法</span>} field="identificationMethodIds" {...formItemLayout}>
          <Select
            className="risk-model-select"
            data={searchCommonData.methodData || []}
            renderOption={item => <Option value={parseInt(item.id)}>{item.name}</Option>}
            values={form.identificationMethodIds.value}
            onChange={value => this.onSelectChange('identificationMethodIds', value)}
          />
        </FormItem>
        <FormItem label={<span>辨识人</span>} field="userIds" {...formItemLayout}>
          <TreeSelect
            value={form.userIds.value === 0 ? undefined : form.userIds.value}
            className="risk-list-select"
            dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
            treeData={searchCommonData.userData || []}
            placeholder="请选择"
            allowClear
            showSearch
            treeNodeFilterProp={'title'}
            treeDefaultExpandAll
            onChange={(e, t, obj) => this.onSelectChange('userIds', e, t, obj)}
          />
        </FormItem>
        <FormItem label={<span>初评人</span>} field="firstEvaluateUserName" {...formItemLayout}>
          <Input value={form.firstEvaluateUserName.value} className="risk-list-input" onChange={e => this.onInputChange('firstEvaluateUserName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>复评人</span>} field="secondEvaluateUserName" {...formItemLayout}>
          <Input value={form.secondEvaluateUserName.value} className="risk-list-input" onChange={e => this.onInputChange('secondEvaluateUserName', e.target.value)} />
        </FormItem>
        <FormItem {...wrapperCol}>
          <Button onClick={this.onClick} className='risk-list-search-button' >查询</Button>
        </FormItem>
      </Form>
    );
  }
}

EquipRiskFactorListSearch.propTypes = {
  search: PropTypes.func,
  searchCommonData: PropTypes.object
};

export default EquipRiskFactorListSearch;
