import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Input, Select, Radio } from 'amos-framework';
import { TreeSelect } from 'amos-antd';
import { getEvaluateModelListAction, queryRiskLevelListByEvModelAction } from './../../../../services/bizService';
import { parseDepartmentTreeData } from '../treeDataProcessor';

const FormItem = Form.Item;
const Option = Select.Option;
const RadioGroup = Radio.Group;
const floorData = [{ id: '1', name: '1层' }, { id: '2', name: '2层' }, { id: '3', name: '3层' }, { id: '4', name: '4层' }, { id: '5', name: '5层' }];

/**
 *
 * 风险点详情
 * @class RiskSourceDetail
 * @extends {Component}
 */
class RiskSourceDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: '',
        code: '',
        riskLevel: '',
        parentId: '',
        floor3d: '1',
        isIndoor: 1,
        position3d: '',
        identificationMethodId: 0,
        userId: 0,
        riskType: ''
      },
      evaluateModelData: [],
      riskLevelData: []
    };
  }

  componentDidMount() {
    const { evaluateModelId } = this.props;
    this.getAllEvaluateModel();
    evaluateModelId && this.getRiskLevelData(evaluateModelId);
  }

  getAllEvaluateModel = () => {
    getEvaluateModelListAction([], 0, -1).then(data => {
      this.setState({ evaluateModelData: data });
    });
  };

  getRiskLevelData = (evModelId) => {
    queryRiskLevelListByEvModelAction(evModelId).then(data => {
      this.setState({ riskLevelData: data });
    });
  }

  render() {
    const {
      riskType,
      userId,
      name,
      code,
      identificationMethodId,
      riskLevel,
      position3d,
      isIndoor,
      floor3d,
      userData = [],
      methodData = [],
      // riskLevelData = [],
      belongDepartmentData = [],
      belongDepartmentId,
      evaluateModelId,
      riskTypeData = [] } = this.props;
    const { form, evaluateModelData, riskLevelData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 2 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <div>
        <div className='risk-source-detail-header'><div className='risk-source-detail-cxt'>风险层级信息</div></div>
        <Form model={form} className="risk-source-detail" style={{ marginLeft: '10px' }} >
          <FormItem label={<span>层级类型</span>} field="riskType" {...formItemLayout}>
            <Select
              className="risk-source-select"
              data={riskTypeData}
              value={riskType}
              disabled
              renderOption={item => <Option value={item.code}>{item.name}</Option>}
            />
          </FormItem>
          <FormItem label={<span>风险名称</span>} field="name" {...formItemLayout}>
            <Input className="risk-source-input" disabled value={name}  />
          </FormItem>
          <FormItem label={<span>参考编号</span>} field="code" {...formItemLayout}>
            <Input className="risk-source-input"  disabled value={code}  />
          </FormItem>
          <FormItem label={<span>风险评价模型</span>} field="evaluateModelId" {...formItemLayout}>
            <Select
              className="risk-source-select"
              data={evaluateModelData}
              value={evaluateModelId}
              renderOption={item => <Option value={item.id}>{item.name}</Option>}
              disabled
            />
          </FormItem>
          <FormItem label={<span>风险等级</span>} field="riskLevel" {...formItemLayout}>
            <Select
              className="risk-source-select"
              data={riskLevelData}
              value={riskLevel ? parseInt(riskLevel) : riskLevel}
              renderOption={item => <Option value={item.id}>{item.level}</Option>}
              disabled
            />
          </FormItem>
          <FormItem label={<span>辨识人</span>} field="userId" {...formItemLayout}>
            <TreeSelect
              value={userId === 0 ? undefined : userId}
              className="risk-source-select"
              treeData={userData}
              placeholder="请选择"
              disabled
            />
          </FormItem>
          <FormItem label={<span>辨识方法</span>} field="identificationMethodId" {...formItemLayout}>
            <Select
              className="risk-source-select"
              data={methodData}
              disabled
              renderOption={item => <Option value={parseInt(item.id)}>{item.name}</Option>}
              value={identificationMethodId}
            />
          </FormItem>
          <FormItem label={<span>存在部门/车间</span>} field="belongDepartmentId" {...formItemLayout}>
            <TreeSelect
              value={belongDepartmentId === 0 ? undefined : belongDepartmentId}
              className="risk-source-select"
              dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
              treeData={belongDepartmentData}
              placeholder="请选择"
              allowClear
              disabled
              treeDefaultExpandAll
              onChange={(e, t, obj) => this.onSelectChange('belongDepartmentId', e, t, obj)}
            />
          </FormItem>
          <FormItem label={<span>3维坐标</span>} field="position3d" {...formItemLayout}>
            <Input className="risk-source-input" value={position3d} disabled />
          </FormItem>
          <FormItem label={<span>3维楼层</span>} field="floor3d" {...formItemLayout}>
            <Select
              className="risk-source-select"
              data={floorData}
              defaultValue='1'
              value={floor3d}
              disabled
              renderOption={item => <Option value={item.id}>{item.name}</Option>}
            />
          </FormItem>
          <FormItem label={<span>是否室内</span>} field="isIndoor" {...formItemLayout}>
            <RadioGroup defaultValue={1} value={isIndoor ? 1 : 0} >
              <Radio value={0} disabled>否</Radio>
              <Radio value={1} disabled>是</Radio>
            </RadioGroup>
          </FormItem>
        </Form>
      </div>
    );
  }
}

RiskSourceDetail.propTypes = {
  riskType: PropTypes.string,
  userId: PropTypes.number,
  name: PropTypes.string,
  identificationMethodId: PropTypes.number,
  riskLevel: PropTypes.string,
  isRegion: PropTypes.string,
  position3d: PropTypes.string,
  isIndoor: PropTypes.bool,
  floor3d: PropTypes.string,
  code: PropTypes.string,
  userData: PropTypes.array,
  methodData: PropTypes.array,
  riskLevelData: PropTypes.array,
  riskTypeData: PropTypes.array,
  evaluateModelId: PropTypes.number,
  belongDepartmentData: PropTypes.array,
  belongDepartmentId: PropTypes.number
};

export default RiskSourceDetail;
