export const parseOtherDeptUser = (treeData) => {
  let otherDeptUserList = treeData.filter(obj => {
    if (obj.parentId === '0' && obj.type === 'user') {
      return true;
    }
  });
  let otherDept = {};
  let children = [];
  otherDeptUserList.map(item => {
    let user = {};
    user.label = item.name;
    user.key = item.id;
    user.value = item.id;
    children.push(user);
  });
  otherDept.label = '其他';
  otherDept.value = '-1';
  otherDept.key = '-1';
  otherDept.disableCheckbox = false;
  otherDept.children = children;
  return otherDept;
};

export const parseTreeData = (treeData) => {
  let deptList = [];
  let userList = [];
  treeData.map(obj => {
    let deptObj = {};
    let userObj = {};
    if (obj.type === 'department') {
      deptObj.label = obj.name;
      deptObj.key = obj.id;
      deptObj.value = obj.id;
      deptObj.type = 'department';
      deptObj.disableCheckbox = true;
      deptList.push(deptObj);
      if (obj.children !== null) {
        deptObj.children = parseTreeData(obj.children);
      }
    } else {
      userObj.label = obj.name;
      userObj.key = obj.id;
      userObj.value = obj.id;
      userObj.type = 'user';
      userList.push(userObj);
    }
  });
  return [...deptList, ...userList];
};

export const returnUserList = (treeData) => {
  let userList = [];
  treeData.map(obj => {
    let deptObj = {};
    let userObj = {};
    if (obj.type === 'department') {
      if (obj.children !== null) {
        deptObj.children = returnUserList(obj.children);
      }
    } else {
      userObj.label = obj.name;
      userObj.key = obj.id;
      userObj.value = obj.id;
      userObj.type = 'user';
      userList.push(userObj);
    }
  });
  return [...userList];
};

export const returnUsers = (treeData,userList) => {
  treeData.map(obj => {
    let deptObj = {};
    let userObj = {};
    if (obj.type === 'department') {
      if (obj.children !== null) {
        deptObj.children = returnUsers(obj.children,userList);
      }
    } else {
      userObj.label = obj.name;
      userObj.key = obj.id;
      userObj.value = obj.id;
      userObj.type = 'user';
      userList.push(userObj);
    }
  });
  return [...userList];
};

export const parseDepartmentTreeData = (treeData) => {
  let deptList = [];
  treeData && treeData.map(obj => {
    let deptObj = {};
    if (obj.type === 'department') {
      if (obj.children !== null) {
        deptObj.children = parseDepartmentTreeData(obj.children);
      }
      deptObj.label = obj.label;
      deptObj.key = obj.key;
      deptObj.value = obj.value;
      deptObj.type = 'department';
      deptObj.disableCheckbox = true;
      deptList.push(deptObj);
    }
  });
  return [...deptList];
};
