import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Form, Button, Select } from 'amos-framework';

const FormItem = Form.Item;
const Option = Select.Option;

/**
 *
 * 查询
 * @class SearchView
 * @extends {Component}
 */
class SearchView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        type: {
          name: 'type',
          type: 'EQUAL',
          value: ''
        },
        code: {
          name: 'code',
          type: 'LIKE',
          value: ''
        },
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        ip: {
          name: 'ip',
          type: 'LIKE',
          value: ''
        }
      }
    };
  }

  componentWillMount() {

  }

  componentDidMount() {

  }

  onInputChange =(key,value)=>{
    const { form } = this.state;
    form[key].value = value;
    this.setState({ form });
  }

  onClick =()=>{
    const { form } = this.state;
    this.props.search(form);
  }

  initFormValues =()=>{
    const { form } = this.state;
    for (let key in form) {
      form[key].value = '';
    }
    this.setState({ form });
  }

  render() {
    const { form } = this.state;
    const { camerasTypeData = [] } = this.props;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 7 }
      }
    };
    return (
      <Form style={{ width: 270, padding: '30px 0 0' }} className="cameras-search" model={form}>
        <FormItem label={<span>摄像机类型</span>} field="type" {...formItemLayout}>
          <Select
            className="search-select"
            data={camerasTypeData}
            renderOption={item => <Option value={item.code}>{item.name}</Option>}
            value={form.type.value}
            onChange={value => this.onInputChange('type', value)}
          />
        </FormItem>
        <FormItem label={<span>摄像机编号</span>} field="code" {...formItemLayout}>
          <Input placeholder="请输入" className='search-input' value={form.code.value}  onChange={(e) => this.onInputChange('code',e.target.value)} />
        </FormItem>
        <FormItem label={<span>摄像机名称</span>} field="name" {...formItemLayout}>
          <Input placeholder="请输入" className='search-input' value={form.name.value}  onChange={(e) => this.onInputChange('name',e.target.value)} />
        </FormItem>
        <FormItem label={<span>摄像机IP</span>} field="ip" {...formItemLayout}>
          <Input placeholder="请输入" className='search-input' value={form.ip.value}  onChange={(e) => this.onInputChange('ip',e.target.value)} />
        </FormItem>
        <FormItem {...wrapperCol}>
          <Button onClick={this.onClick}>查询</Button><Button  type="minor" onClick={this.initFormValues}>重置</Button>
        </FormItem>
      </Form>
    );
  }
}

SearchView.propTypes = {
  search: PropTypes.func,
  camerasTypeData: PropTypes.arry
};

export default SearchView;
