import React, { Component } from 'react';
import PropTypes from 'prop-types';
import CamerasTable from './CamerasTable';
import SearchView from './SearchView';
import SplitterLayout from '../../../common/side/SideQueryLayout';
import { getCamerasDataAction,getCamerasTypeAction } from './../../../../services/bizService';

/**
 *
 *摄像头
 * @class Cameras
 * @extends {Component}
 */
class Cameras extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      pageNumber: 0,
      pageSize: 10
    };
    this.state = {
      showQuery: false,
      totalNum: 0,
      camerasData: [],
      camerasTypeData: []
    };
  }

  componentWillMount() {

  }

  componentDidMount() {
    this.getCamerasTypeData();
  }

  setSearchAndSearch =(form)=>{
    let searchParam = [];
    for (let key in form ){
      searchParam.push(form[key]);
    }
    this.setState({ searchParam },()=>this.questStatistiscData(this.pageConfig));
  }

  changeStatus = (open) => {
    this.setState({ showQuery: open });
  }

  questStatistiscData = (param, _table) => {
    if (_table && _table.state) {
      _table.state.selectedRowKeys = [];
      _table.state.selectedRows = [];
    }
    const { searchParam } = this.state;
    if (param.current != null) {
      param.pageNumber = param.current;
    }
    const { pageNumber, pageSize } = param;
    this.fetchCamerasData(searchParam,pageNumber,pageSize);
  }

  fetchCamerasData =(searchParam,pageNumber,pageSize)=>{
    getCamerasDataAction(searchParam,pageNumber,pageSize).then(data=>{
      this.setState({ totalNum: data.totalElements,camerasData: data.content });
    });
  }

  loopChangeStatus = (open) => {
    const { showQuery } = this.state;
    showQuery ? this.setState({ showQuery: false }) : this.setState({ showQuery: true });
    this.search.initFormValues();
  }

  getCamerasTypeData =()=>{
    getCamerasTypeAction().then(data=>{
      this.setState({ camerasTypeData: data });
    });
  }

  render() {
    const { showQuery,totalNum,camerasData, camerasTypeData } = this.state;
    return (
      <div className='cameras-root'>
        <SplitterLayout open={showQuery} callback={this.changeStatus}>
          <SearchView search={this.setSearchAndSearch} camerasTypeData={camerasTypeData} ref={node=>this.search = node} />
        </SplitterLayout>
        <CamerasTable fetchData={this.questStatistiscData} camerasTypeData={camerasTypeData} changeStatus={this.loopChangeStatus} totalNum={totalNum} dataList={camerasData} />
      </div>
    );
  }
}

Cameras.propTypes = {
  location: PropTypes.object
};

export default Cameras;
