import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Form, Select,Button } from 'amos-framework';
import { getRegionDepartmentTreeAction, getDepatUserListAction, getRiskSourceByTypeAction } from '../../../../services/bizService';

const FormItem = Form.Item;
const Option = Select.Option;

/**
 * 设备设施查询页面
 *
 * @class EquipFacilitiesSearch
 * @extends {Component}
 */
class EquipFacilitiesSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        regionId: {
          name: 'regionId',
          type: 'EQUAL',
          value: ''
        },
        departmentId: {
          name: 'departmentId',
          type: 'EQUAL',
          value: ''
        },
        workshopSection: {
          name: 'workshopSection',
          type: 'LIKE',
          value: ''
        },
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        code: {
          name: 'code',
          type: 'LIKE',
          value: ''
        },
        type: {
          name: 'type',
          type: 'EQUAL',
          value: ''
        },
        leaderDepartmentId: {
          name: 'leaderDepartmentId',
          type: 'EQUAL',
          value: ''
        },
        leaderUserId: {
          name: 'leaderUserId',
          type: 'EQUAL',
          value: ''
        }
      },
      regionData: [],
      deptData: [],
      chargerDeptData: [],
      chargerPersonData: [],
      regionDepartmentTree: []
    };
  }

  componentDidMount() {
    this.getRegionData();
    this.getRiskSource('02');//风险区域
  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  };

  onSelectChange(key, value) {
    let { form } = this.state;
    form[key].value = value;
    if (key === 'leaderDepartmentId') {
      getDepatUserListAction(value).then(data => {
        let { form, chargerPersonData } = this.state;
        chargerPersonData = [];
        data.map(item => {
          let user = {};
          user.name = item.realName;
          user.id = item.userId;
          chargerPersonData.push(user);
        });
        form.leaderUserId.value = '';
        this.setState({ form, chargerPersonData });
      });
    }
    this.setState({ form });
  }

  onClick = () => {
    const { form } = this.state;
    this.props.search(form);
  }

  getRegionData =()=> {
    getRegionDepartmentTreeAction().then(data => {
      this.setState({ regionDepartmentTree: data },()=>this.getDeptData());
    });
  }

  getRiskSource = type => {
    getRiskSourceByTypeAction(type).then(data => {
      this.setState({ regionData: data });
    });
  }

  getDeptData = () => {
    let { regionDepartmentTree, deptData } = this.state;
    let depatData = regionDepartmentTree.secondDepartments;
    deptData = [];
    for (let key in depatData ) {
      depatData[key].map(item =>{
        let deptObj = {};
        deptObj.id = item.sequenceNbr;
        deptObj.name = item.departmentName;
        deptData.push(deptObj);
      });
    }
    this.setState({ deptData, chargerDeptData: deptData });
  };

  initFormValues =()=>{
    const { form } = this.state;
    for (let key in form) {
      form[key].value = '';
    }
    this.setState({ form });
  }

  render() {
    const { form, regionData, deptData, chargerDeptData, chargerPersonData } = this.state;
    const { equipTypeData = [] } = this.props;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 9 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 7 }
      }
    };

    return (
      <Form style={{ padding: '30px 0 0 0px' }} className="point-search" model={form}>
        <FormItem label={<span>所在风险区域</span>} field="regionId" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={regionData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.regionId.value}
            onChange={e => this.onSelectChange('regionId', e)}
          />
        </FormItem>
        <FormItem label={<span>部门/车间</span>} field="departmentId" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={deptData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.departmentId.value}
            onChange={e => this.onSelectChange('departmentId', e)}
          />
        </FormItem>
        <FormItem label={<span>所属工段</span>} field="workshopSection" {...formItemLayout}>
          <Input value={form.workshopSection.value} className="search_Input" onChange={e => this.onChange('workshopSection', e)} />
        </FormItem>
        <FormItem label={<span>设备名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} className="search_Input" onChange={e => this.onChange('name', e)} />
        </FormItem>
        <FormItem label={<span>设备位号</span>} field="code" {...formItemLayout}>
          <Input value={form.code.value} className="search_Input" onChange={e => this.onChange('code', e)} />
        </FormItem>
        <FormItem label={<span>设备类型</span>} field="type" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={equipTypeData}
            renderOption={item => <Option value={item.code}>{item.name}</Option>}
            value={form.type.value}
            onChange={e => this.onSelectChange('type', e)}
          />
        </FormItem>
        <FormItem label={<span>责任部门</span>} field="leaderDepartmentId" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={chargerDeptData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.leaderDepartmentId.value}
            onChange={e => this.onSelectChange('leaderDepartmentId', e)}
          />
        </FormItem>
        <FormItem label={<span>责任人</span>} field="leaderUserId" {...formItemLayout}>
          <Select
            className="risk_factor_select"
            data={chargerPersonData || []}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.leaderUserId.value}
            onChange={e => this.onSelectChange('leaderUserId', e)}
          />
        </FormItem>
        <FormItem {...wrapperCol}>
          <Button onClick={this.onClick} style={{ background: '#19afff' }}>查询</Button>
          <Button  style={{ background: 'transparent', marginLeft: '0.8rem !important', color: 'black' }} onClick={this.initFormValues}>重置</Button>
        </FormItem>
      </Form>
    );
  }
}

EquipFacilitiesSearch.propTypes = {
  equipTypeData: PropTypes.arry,
  search: PropTypes.func
};

export default EquipFacilitiesSearch;
