import React, { Component } from 'react';
import { Button } from 'amos-framework';
import  PropTypes from 'prop-types';
import EquipFacilitiesSearch from './EquipFacilitiesSearch';

class SearchView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      activeKey: ''
    };
  }

  componentDidMount() {}

  onClick = () => {
    const { search } = this.props;
    search && this.search && search(this.search.state.form);
  }

  getRenderContent = () => {
    return <EquipFacilitiesSearch ref={node => this.search = node} />;
  }

  render() {

    return (
      <div className='search-view'>
        {this.props.children}
        <div className='search-view-buttons' style={{ textAlign: 'center' }}>
          <Button onClick={() => this.onClick()} style={{ background: '#19afff' }}>查询</Button>
          <Button onClick={() => this.onClick()} style={{ background: 'transparent', marginLeft: '0.8rem !important', color: 'black' }}>重置</Button>
        </div>
      </div>
    );
  }
}

SearchView.propTypes = {
  search: PropTypes.func
};
export default SearchView;
