import React, { Component } from 'react';
import { Button } from 'amos-framework';
import  PropTypes from 'prop-types';
import DangerSourceClassifySearch from './dangerSourceClassify/DangerSourceClassifySearch';
import PossibleConsequenceSearch from './possibleConsequence/PossibleConsequenceSearch';
import ControlModelSearch from './controlModel/ControlModelSearch';

class SearchView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      activeKey: ''
    };
  }

  componentDidMount() {}

  onClick = () => {
    const { search } = this.props;
    search && this.search && search(this.search.state.form);
  }

  getRenderContent = (activeKey) => {
    if (activeKey === '1') {
      return <DangerSourceClassifySearch ref={node=>this.search = node} />;
    } else if (activeKey === '2') {
      return <PossibleConsequenceSearch ref={node=>this.search = node} />;
    } else if (activeKey === '3') {
      return <ControlModelSearch ref={node=>this.search = node} />;
    }
  }

  render() {
    let { activeKey } = this.props;

    return (
      <div className='search-view'>
        {this.getRenderContent(activeKey)}
        <div className="search-item" style={{ textAlign: 'center' }}>
          <Button onClick={() => this.onClick()}  style={{ background: '#19afff' }}>查询</Button>
          <Button onClick={() => this.search.initSearchFileds()}  style={{ background: '#19afff', marginLeft: '10px !important' }}>重置</Button>
        </div>
      </div>
    );
  }
}

SearchView.propTypes = {
  activeKey: PropTypes.string,
  search: PropTypes.func
};
export default SearchView;

