import React, { Component } from 'react';
import { Tabs } from 'amos-framework';
import { queryHazardSourceClassifyAction, querySpcAftermathAction, queryControlMeasureAction } from '../../../../services/bizService';
import DangerSourceClassify from './dangerSourceClassify';
import DangerSourceClassifyToolBar from './dangerSourceClassify/DangerSourceClassifyToolBar';
import PossibleConsequence from './possibleConsequence';
import PossibleConsequenceToolBar from './possibleConsequence/PossibleConsequenceToolBar';
import ControlModelView from './controlModel';
import ControlModelToolBar from './controlModel/ControlModelToolBar';
import SplitterLayout from '../../../common/side/SideQueryLayout';
import SearchView from './SearchView';

const { TabList, Tab, TabPanel } = Tabs;

const tabs = [
  { id: '1', closable: false, title: '危险源分类' },
  { id: '2', closable: false, title: '可能造成的后果' },
  { id: '3', closable: false, title: '管控措施' }
];

/**
 * 参数设置
 *
 * @class RiskKnowledgeMgt
 * @extends {Component}
 */
class RiskKnowledgeMgt extends Component {
  constructor(props) {
    super(props);
    let activeKey = '1';
    this.pageConfig = {
      pageNumber: 0,
      pageSize: 10
    };
    const newLocal = this.props.location;
    if (newLocal.state && newLocal.state.activeKey) {
      activeKey = newLocal.state.activeKey;
    }
    this.state = {
      activeKey,
      showQuery: false,
      searchParam: [],
      dataList: [],
      totalNum: 0
    };
  }

  componentWillMount() {}

  onTabClick = value => {
    this.initData(value);
  };

  onButtonClick = toolBarFlag => {
    this.setState({ toolBarFlag });
    if (toolBarFlag === '4') {
      this.setState({ showQuery: true });
    }
  };

  getToolBar = activeKey => {
    if (activeKey === '1') {
      return <DangerSourceClassifyToolBar onButtonClick={this.onButtonClick} />;
    } else if (activeKey === '2') {
      return <PossibleConsequenceToolBar onButtonClick={this.onButtonClick} />;
    } else if (activeKey === '3') {
      return <ControlModelToolBar onButtonClick={this.onButtonClick} />;
    }
  };

  requestMethod = type => {
    if (type === '4') {
      this.queryEvaModel('');
    }
  };

  //条件查询
  searchTableDate = searchParam => {
    let param = { pageNumber: this.pageConfig.pageNumber, pageSize: this.pageConfig.pageSize };
    this.setState({ searchParam }, () => this.questStatistiscData(param));
  };

  queryHazardSourceClassify = (searchParam, pageNumber, pageSize) => {
    queryHazardSourceClassifyAction(searchParam, pageNumber, pageSize).then(data => {
      this.setState({ dataList: data.content, totalNum: data.totalElements, toolBarFlag: '' });
    });
  };

  querySpcAftermath = (searchParam, pageNumber, pageSize) => {
    querySpcAftermathAction(searchParam, pageNumber, pageSize).then(data => {
      this.setState({ dataList: data.content, totalNum: data.totalElements, toolBarFlag: '' });
    });
  };

  queryControlMeasure = (searchParam, pageNumber, pageSize) => {
    queryControlMeasureAction(searchParam, pageNumber, pageSize).then(data => {
      this.setState({ dataList: data.content, totalNum: data.totalElements, toolBarFlag: '' });
    });
  };

  questStatistiscData = (param, _table) => {
    if (_table && _table.state) {
      _table.state.selectedRowKeys = [];
      _table.state.selectedRows = [];
    }
    let { searchParam, activeKey } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    let { pageNumber, pageSize } = param;
    if (activeKey === '1') {
      this.queryHazardSourceClassify(searchParam, pageNumber, pageSize);
    } else if (activeKey === '2') {
      this.querySpcAftermath(searchParam, pageNumber, pageSize);
    } else if (activeKey === '3') {
      this.queryControlMeasure(searchParam, pageNumber, pageSize);
    }
  };

  getSearchContent = () => {

  }

  initData = value => {
    this.setState({ activeKey: value, searchParam: [], form: null, toolBarFlag: '' }, () => this.requestMethod(value));
  };

  changeStatus = (open) => {
    this.setState({ showQuery: open });
  }

  setSearchAndSearch =(form)=>{
    let searchParam = [];
    for (let key in form ){
      searchParam.push(form[key]);
    }
    this.setState({ searchParam },()=>this.questStatistiscData(this.pageConfig));
  }

  initToolbarFlag = () => {
    this.setState({ toolBarFlag: '' });
  }

  render() {
    let { activeKey,toolBarFlag,dataList,totalNum,showQuery } = this.state;
    return (
      <div className="tabs-outside-precontrol">
        <SplitterLayout open={showQuery} callback={this.changeStatus}>
          <SearchView activeKey={activeKey} search={this.setSearchAndSearch} />
        </SplitterLayout>
        <Tabs activeKey={activeKey} onChange={(index, key) => this.onTabClick(key)} destroyContent closeAnimate cardMode>
          <TabList>
            {tabs.map((item, i) => (
              <Tab key={item.id} activeKey={item.id} closable={item.closable}>
                {item.title}
              </Tab>
            ))}
            {this.getToolBar(activeKey)}
          </TabList>
          <TabPanel activeKey="1">
            <DangerSourceClassify
              dataList={dataList}
              activeKey={activeKey}
              toolBarFlag={toolBarFlag}
              totalCount={totalNum}
              fetchData={this.questStatistiscData}
              initToolbarFlag={this.initToolbarFlag}
            />
          </TabPanel>
          <TabPanel activeKey="2">
            <PossibleConsequence
              dataList={dataList}
              activeKey={activeKey}
              toolBarFlag={toolBarFlag}
              totalCount={totalNum}
              fetchData={this.questStatistiscData}
              initToolbarFlag={this.initToolbarFlag}
            />
          </TabPanel>
          <TabPanel activeKey="3">
            <ControlModelView
              dataList={dataList}
              activeKey={activeKey}
              toolBarFlag={toolBarFlag}
              totalCount={totalNum}
              fetchData={this.questStatistiscData}
              initToolbarFlag={this.initToolbarFlag}
            />
          </TabPanel>
        </Tabs>

      </div>
    );
  }
}

RiskKnowledgeMgt.propTypes = {};

export default RiskKnowledgeMgt;
