import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, AmosAlert, Input } from 'amos-framework';
import { spcAftermathSaveAction } from '../../../../../services/bizService';

const FormItem = Form.Item;
const TextArea = Input.TextArea;
/**
 *后果新增及编辑
 */
class PossibleConsequenceModel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [],
      form: {
        name: '',
        describe: ''
      },
      rules: {
        name: [{ required: true, message: '后果名称不能为空' },{ max: 30, message: '长度不能大于30个字符' }],
        describe: [{ max: 200, message: '长度不能大于200个字符' }]
      }
    };
  }

  componentWillMount = () => {
    const { selectRowData } = this.props || {};
    if (selectRowData) {
      let form = {};
      Object.assign(form, selectRowData);
      this.setState({ form });
    }
  };

  onChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  }

  handleSubmit = e => {
    this.form.validate((valid, dataValues) => {
      if (valid) {
        let { form } = this.state;
        this.spcAftermathSave(form);
      } else {
        return false;
      }
    });
  };

  spcAftermathSave = body => {
    spcAftermathSaveAction(body).then(
      data => {
        AmosAlert.success('提示', '操作成功');
        this.props.reloadPage();
      },
      err => {
        AmosAlert.error('提示', err);
      }
    );
  };

  render() {
    const { form, rules } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <div className="risk-factor-model possible-consequence">
        <Form model={form} rules={rules} ref={component => this.form = component}>
          <FormItem label={<span>后果名称</span>} field="name" {...formItemLayout}>
            <Input className="risk_factor_input"  value={form.name} onChange={e => this.onChange('name', e.target.value)} />
          </FormItem>
          <FormItem label={<span>备注</span>} field="describe" {...formItemLayout}>
            <TextArea rows={10} cols={20} className="risk_factor_input" value={form.describe} onChange={e => this.onChange('describe', e.target.value)} />
          </FormItem>
        </Form>
      </div>
    );
  }
}

PossibleConsequenceModel.propTypes = {
  reloadPage: PropTypes.func
};
export default PossibleConsequenceModel;
