import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal, AmosAlert } from 'amos-framework';
import AmosGridTable from './../../../common/tableComponent/table/AmosGridTable';
import { spcAftermathDeleteAction } from '../../../../../services/bizService';
import PossibleConsequenceModel from './PossibleConsequenceModel';

const getColumns = () => {
  return [
    {
      title: '序号',
      render: (text, record, index) => `${index + 1}`
    },
    {
      title: '后果名称',
      dataIndex: 'name',
      key: 'name',
      width: '30%'
    },
    {
      title: '备注',
      dataIndex: 'describe',
      key: 'describe',
      width: '60%'
    }
  ];
};

/**
 * 可能造成的后果
 *
 * @class PossibleConsequence
 * @extends {Component}
 */
class PossibleConsequence extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      pagination: true,
      isChecked: true,
      modal: false,
      selectedRows: [],
      selectedRowKeys: [],
      data: [],
      searchParam: []
    };
  }

  componentWillReceiveProps(newProps) {
    let { toolBarFlag, activeKey, initToolbarFlag } = newProps;
    if (activeKey && activeKey === '2' && toolBarFlag) {
      this.checkData(toolBarFlag);
      initToolbarFlag();
    }
  }

  checkData = toolBarFlag => {
    let { selectedRowKeys } = this.state;
    if (toolBarFlag === '1') {
      //新增
      this.setState({ modal: true, toolBarFlag });
    } else if (toolBarFlag === '2') {
      //编辑
      if (selectedRowKeys === undefined || selectedRowKeys.length <= 0) {
        AmosAlert.warning('提示', '请先点击选择编辑的行');
        return;
      } else {
        this.setState({ modal: true, toolBarFlag });
      }
    } else if (toolBarFlag === '3') {
      //删除
      if (selectedRowKeys === undefined || selectedRowKeys.length <= 0) {
        AmosAlert.warning('提示', '请先点击选择删除的行');
        return;
      } else {
        this.spcAftermathDelete(selectedRowKeys);
      }
    }
  };

  /**
   * 分页设置参数
   */
  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.pageNumber = current;
    }
  };

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  };

  getRowClassName = (record, index) => {
    let { selectedRowKeys } = this.state;
    if (selectedRowKeys.findIndex(item => item === record.id) >= 0) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  };

  onRowClick = record => {
    let { selectedRowKeys, selectedRows } = this.state;
    let exist = false;
    selectedRows.find(item => {
      if (item.id === record.id) {
        exist = true;
      }
    });
    if (exist) {
      selectedRows.splice(selectedRows.findIndex(item => item.id === record.id), 1);
      selectedRowKeys.splice(selectedRowKeys.findIndex(item => item === record.id), 1);
    } else {
      selectedRows.push(record);
      selectedRowKeys.push(record.id);
    }
    this.setState({
      selectedRows,
      selectedRowKeys
    });
  };

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  clearSelectedRows = () => {
    this.setState({ selectedRows: [], selectedRowKeys: [], modal: false, toolBarFlag: '' });
  };

  reloadPage = () => {
    this.clearSelectedRows();
    this.state.reload();
  };

  getContext = toolBarFlag => {
    if (toolBarFlag) {
      if (toolBarFlag === '1') {
        //新增
        return <PossibleConsequenceModel reloadPage={this.reloadPage} ref={component => this.model = component} />;
      } else {
        const { selectedRows } = this.state;
        return <PossibleConsequenceModel reloadPage={this.reloadPage} selectRowData={selectedRows[0]} ref={component => this.model = component} />;
      }
    }
  };

  cancel = () => {
    this.setState({ modal: false });
  };

  onOk = () => {
    this.model.handleSubmit();
  };

  spcAftermathDelete = body => {
    AmosAlert.confirm('提示', '确定要删除么?', {
      callback: flag => {
        if (flag) {
          // 确定
          spcAftermathDeleteAction(body).then(
            data => {
              AmosAlert.success('提示', '删除成功');
              this.reloadPage();
            },
            err => {
              AmosAlert.error('错误', err);
              this.reloadPage();
            }
          );
        }
      }
    });
  };

  render() {
    let { pagination, isChecked, selectedRowKeys, modal, toolBarFlag } = this.state;
    const { dataList, totalCount, fetchData } = this.props;
    let defaultPageConfig = this.pageConfig;
    return (
      <div className="patrol-page-table">
        <AmosGridTable
          columns={getColumns()}
          callBack={this.reload}
          isPageable={pagination}
          dataList={dataList}
          totals={totalCount}
          getTableDataAction={param => fetchData(param, this)}
          selectedRowKeys={selectedRowKeys}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          onRowClick={this.onRowClick}
          isChecked={isChecked}
        />
        <Modal
          header={toolBarFlag === '1' ? '添加可能造成的后果' : '编辑可能造成的后果'}
          visible={modal}
          destroyContent
          className="param-model"
          content={this.getContext(toolBarFlag)}
          onCancel={() => this.cancel()}
          onOk={() => this.onOk()}
          okText="确定"
          cancelText="取消"
          outterClosable={false}
        />
      </div>
    );
  }
}

PossibleConsequence.propTypes = {
  dataList: PropTypes.array,
  totalCount: PropTypes.number,
  fetchData: PropTypes.func,
  initToolbarFlag: PropTypes.func
};
export default PossibleConsequence;
