import React, { Component } from 'react';
import { Form, AmosAlert, Input } from 'amos-framework';
import { identificationMethodSaveAction } from '../../../../../services/bizService';

const FormItem = Form.Item;
const TextArea = Input.TextArea;

/**
 * 辨识方法模型
 *
 * @class IdentityMethodModel
 * @extends {Component}
 */
class IdentityMethodModel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [],
      form: {
        name: '',
        code: '',
        description: ''
      },
      rules: {
        name: [{ required: true, message: '辨识方法名称不能为空' },{ max: 50, message: '长度不能大于50个字符',}],
        code: [{ required: true, message: '代号不能为空' },{ max: 50, message: '长度不能大于50个字符',}],
        description: [{ required: true, message: '适用对象不能为空' },{ max: 50, message: '长度不能大于50个字符',}]
      }
    };
  }

  componentWillMount = () => {
    const { selectRowData } = this.props || {};
    if (selectRowData) {
      let form = {};
      Object.assign(form, selectRowData);
      this.setState({ form });
    }
  };

  onInputChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  };

  handleSubmit = e => {
    this.form.validate((valid, dataValues) => {
      if (valid) {
        let { form } = this.state;
        this.identificationMethodSave(form);
      } else {
        return false;
      }
    });
  };

  identificationMethodSave = body => {
    identificationMethodSaveAction(body).then(
      data => {
        AmosAlert.success('提示', '操作成功');
        this.props.reloadPage();
      },
      err => {
        AmosAlert.error('提示', err);
      }
    );
  };

  render() {
    const { form, rules } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <div>
        <Form model={form} rules={rules} ref={component => this.form = component}>
          <FormItem label={<span>辨识方法名称</span>} field="name" {...formItemLayout}>
            <Input className='risk_factor_input' value={form.name} onChange={e => this.onInputChange('name', e.target.value)} />
          </FormItem>
          <FormItem label={<span>代号</span>} field="code" {...formItemLayout}>
            <Input className='risk_factor_input' value={form.code} onChange={e => this.onInputChange('code', e.target.value)} />
          </FormItem>
          <FormItem label={<span>适用对象</span>} field="description" {...formItemLayout}>
            <TextArea rows={10} cols={20} className="risk_factor_input" value={form.description} onChange={e => this.onInputChange('description', e.target.value)} />
          </FormItem>
        </Form>
      </div>
    );
  }
}

export default IdentityMethodModel;
