import React, { Component } from 'react';
import { Tabs, AmosAlert } from 'amos-framework';
import {
  getIdentificationMethodAction,
  getEvaluateModelListAction,
  getRiskLevelListAction,
  getEvaluateCriteriaListAction
} from './../../../../services/bizService';
import RiskIdentityMethod from './identifyMethod/index';
import IdentityMethodToolBar from './identifyMethod/IdentityMethodToolBar';
import RiskEvaluationCriteria from './evaluationCriteria/index';
import EvaluationCriteriaToolBar from './evaluationCriteria/EvaluationCriteriaToolBar';
import RiskLevel from './riskLevel';
import RiskLevelToolBar from './riskLevel/RiskLevelToolBar';
import EvaluationModel from './evaluationModel';
import EvaluationModelToolBar from './evaluationModel/EvaluationModelToolBar';
import SplitterLayout from '../../../common/side/SideQueryLayout';
import SearchView from './SearchView';

const { TabList, Tab, TabPanel } = Tabs;

const tabs = [
  { id: '1', closable: false, title: '风险辨识方法' },
  { id: '2', closable: false, title: '风险评价模型' },
  { id: '3', closable: false, title: '风险等级' },
  { id: '4', closable: false, title: '风险评价准则' }
];

/**
 * 风险模型管理
 *
 * @class RiskModelMgt
 * @extends {Component}
 */
class RiskModelMgt extends Component {
  constructor(props) {
    super(props);
    let activeKey = '1';
    this.pageConfig = {
      pageNumber: 0,
      pageSize: 10
    };
    const newLocal = this.props.location;
    if (newLocal.state && newLocal.state.activeKey) {
      activeKey = newLocal.state.activeKey;
    }
    this.state = {
      activeKey,
      showQuery: false,
      identificationMethodDataList: [],
      identificationMethodTotalNum: 0,
      evaluateModelDataList: [],
      evaluateModelTotalNum: 0,
      riskLevelDataList: [],
      riskLevelTotalNum: 0,
      evaluateCriteriaDataList: [],
      evaluateCriteriaTotalNum: 0,
      searchParam: []
    };
  }

  componentWillMount() {}

  onTabClick = value => {
    this.initData(value);
  };

  onButtonClick = toolBarFlag => {
    if (toolBarFlag === '4') {
      this.setState({ showQuery: true });
    }
    this.setState({ toolBarFlag });
  };

  onEvaModelSelectChange = (evaModel) => {
    let targetEvaModel = { name: 'evaluateModelId', type: '', value: evaModel.id };
    let param  = {};
    Object.assign(param, this.pageConfig);
    param.targetEvaModel = targetEvaModel;
    this.setState({ evaModel }, () => this.questStatistiscData(param, this));
  };

  onTabChange = (record, activeKey) => {
    this.setState({ evaModel: record, activeKey });
  }

  getToolBar = activeKey => {
    let { evaModel } = this.state;
    if (activeKey === '1') {
      return <IdentityMethodToolBar onButtonClick={this.onButtonClick} searchTableDate={this.searchTableDate} />;
    } else if (activeKey === '2') {
      return <EvaluationModelToolBar onButtonClick={this.onButtonClick} searchTableDate={this.searchTableDate} />;
    } else if (activeKey === '3') {
      return <RiskLevelToolBar onButtonClick={this.onButtonClick} searchTableDate={this.searchTableDate} evaModel={evaModel} onEvaModelSelectChange={this.onEvaModelSelectChange} />;
    } else if (activeKey === '4') {
      return <EvaluationCriteriaToolBar onButtonClick={this.onButtonClick} searchTableDate={this.searchTableDate} evaModel={evaModel} onEvaModelSelectChange={this.onEvaModelSelectChange} />;
    }
  };

  getSearchContent = () => {

  }

  setSearchAndSearch =(form)=>{
    let searchParam = [];
    for (let key in form ){
      searchParam.push(form[key]);
    }
    this.setState({ searchParam }, ()=>this.questStatistiscData(this.pageConfig));
  }

  queryIdentificationMethod = (searchParam, pageNumber, pageSize) => {
    getIdentificationMethodAction(searchParam, pageNumber, pageSize).then(
      data => {
        this.setState({ identificationMethodDataList: data.content, identificationMethodTotalNum: data.totalElements, toolBarFlag: '' });
      },
      err => {
        AmosAlert.error('获取风险辨识方法列表失败', err);
      });
  };

  queryEvaluateModelList = (searchParam, pageNumber, pageSize) => {
    getEvaluateModelListAction(searchParam, pageNumber, pageSize).then(data => {
      this.setState({ evaluateModelDataList: data.content, evaluateModelTotalNum: data.totalElements, toolBarFlag: '' });
    });
  };

  queryRiskLevel = (searchParam, pageNumber, pageSize) => {
    getRiskLevelListAction(searchParam, pageNumber, pageSize).then(data => {
      this.setState({ riskLevelDataList: data.content, riskLevelTotalNum: data.totalElements, toolBarFlag: '' });
    });
  };

  queryEvaluateCriteria = (searchParam, pageNumber, pageSize) => {
    getEvaluateCriteriaListAction(searchParam, pageNumber, pageSize).then(data => {
      this.setState({ evaluateCriteriaDataList: data.content, evaluateCriteriaTotalNum: data.totalElements, toolBarFlag: '' });
    });
  };

  questStatistiscData = (param, _table) => {
    if (_table && _table.state) {
      _table.state.selectedRowKeys = [];
      _table.state.selectedRows = [];
    }
    let { searchParam, activeKey, evaModel } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    let { pageNumber, pageSize, targetEvaModel } = param;
    if (activeKey === '1') {
      this.queryIdentificationMethod(searchParam, pageNumber, pageSize);
    } else if (activeKey === '2') {
      this.queryEvaluateModelList(searchParam, pageNumber, pageSize);
    } else if (activeKey === '3') {
      if (!targetEvaModel && evaModel) {
        targetEvaModel = { name: 'evaluateModelId', type: '', value: evaModel.id };
      }
      searchParam = searchParam.filter(item => item && (item.name !== targetEvaModel.name));
      searchParam.push(targetEvaModel);
      targetEvaModel && this.queryRiskLevel(searchParam, pageNumber, pageSize);
    } else if (activeKey === '4') {
      if (!targetEvaModel && evaModel) {
        targetEvaModel = { name: 'evaluateModelId', type: '', value: evaModel.id };
      }
      searchParam = searchParam.filter(item => item);
      searchParam = searchParam.filter(item => item.name !== targetEvaModel.name);
      searchParam.push(targetEvaModel);
      targetEvaModel && this.queryEvaluateCriteria(searchParam, pageNumber, pageSize);
    }
  };

  //条件查询
  searchTableDate = searchParam => {
    let param = { pageNumber: this.pageConfig.pageNumber, pageSize: this.pageConfig.pageSize };
    this.setState({ searchParam }, () => this.questStatistiscData(param));
  };

  initData = value => {
    this.setState({ activeKey: value, searchParam: [], form: null, toolBarFlag: '' });
  };

  changeStatus = (open) => {
    this.setState({ showQuery: open });
  }

  initToolbarFlag = () => {
    this.setState({ toolBarFlag: '' });
  }

  render() {
    let {
      activeKey,
      toolBarFlag,
      identificationMethodDataList,
      identificationMethodTotalNum,
      evaluateModelDataList,
      evaluateModelTotalNum,
      riskLevelDataList,
      riskLevelTotalNum,
      evaluateCriteriaDataList,
      evaluateCriteriaTotalNum,
      showQuery,
      evaModel
    } = this.state;
    return (
      <div className="tabs-outside-precontrol">
        <SplitterLayout open={showQuery} callback={this.changeStatus}>
          <SearchView activeKey={activeKey} search={this.setSearchAndSearch} />
        </SplitterLayout>
        <Tabs activeKey={activeKey} onChange={(index, key) => this.onTabClick(key)} destroyContent closeAnimate cardMode>
          <TabList>
            {tabs.map((item, i) => (
              <Tab key={item.id} activeKey={item.id} closable={item.closable}>
                {item.title}
              </Tab>
            ))}
            {this.getToolBar(activeKey)}
          </TabList>
          <TabPanel activeKey="1">
            <RiskIdentityMethod
              dataList={identificationMethodDataList}
              activeKey={activeKey}
              toolBarFlag={toolBarFlag}
              totalCount={identificationMethodTotalNum}
              fetchData={this.questStatistiscData}
              initToolbarFlag={this.initToolbarFlag}
            />
          </TabPanel>
          <TabPanel activeKey="2">
            <EvaluationModel
              dataList={evaluateModelDataList}
              totalCount={evaluateModelTotalNum}
              fetchData={this.questStatistiscData}
              activeKey={activeKey}
              toolBarFlag={toolBarFlag}
              onTabChange={this.onTabChange}
              initToolbarFlag={this.initToolbarFlag}
            />
          </TabPanel>
          <TabPanel activeKey="3">
            <RiskLevel
              dataList={riskLevelDataList}
              totalCount={riskLevelTotalNum}
              fetchData={this.questStatistiscData}
              activeKey={activeKey}
              toolBarFlag={toolBarFlag}
              evaModel={evaModel}
              initToolbarFlag={this.initToolbarFlag}
            />
          </TabPanel>
          <TabPanel activeKey="4">
            <RiskEvaluationCriteria
              dataList={evaluateCriteriaDataList}
              activeKey={activeKey}
              toolBarFlag={toolBarFlag}
              totalCount={evaluateCriteriaTotalNum}
              fetchData={this.questStatistiscData}
              evaModel={evaModel}
              initToolbarFlag={this.initToolbarFlag}
            />
          </TabPanel>
        </Tabs>
      </div>
    );
  }
}

RiskModelMgt.propTypes = {};

export default RiskModelMgt;
