import React, { Component } from 'react';
import { TreeSelect } from 'amos-antd';
import { Input, Form, Select } from 'amos-framework';
import { getCompanyUserTreeAction } from './../../../../../services/bizService';
import { parseTreeData } from './../../../preControl/treeDataProcessor';

const FormItem = Form.Item;
const Option = Select.Option;

/**
 * 风险等级查询页面
 *
 * @class RiskLevelSearch
 * @extends {Component}
 */
class RiskLevelSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        level: {
          name: 'level',
          value: ''
        },
        describe: {
          name: 'describe',
          type: 'LIKE',
          value: ''
        },
        maintenance: {
          name: 'creatorId',
          value: ''
        }
      },
      maintenancesData: []
    };
  }

  componentDidMount() {
    this.queryUserByCompany();
  }

  componentWillReceiveProps(nextProps) {

  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  };

  onSelectChange(key, value, t, obj) {
    const { form } = this.state;
    if (obj && obj.triggerNode && obj.triggerNode.props && obj.triggerNode.props.type === 'department') {
      return;
    }
    form[key].value = value;
    this.setState({ form });
  }

  queryUserByCompany = () => {
    getCompanyUserTreeAction().then(data => {
      this.parseTreeData(data);
    });
  }

  // 解析返回的部门人员树，供TreeSelect使用
  parseTreeData = (treeList) => {
    let { maintenancesData } = this.state;
    maintenancesData = parseTreeData(treeList);
    this.setState({ maintenancesData });
  }

  render() {
    const { form, maintenancesData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ width: 270, padding: '30px 0 0 0px', marginLeft: 'auto' }} className="point-search" model={form}>
        <FormItem label={<span>风险等级</span>} field="level" {...formItemLayout}>
          <Input value={form.level.value} className="search_Input" onChange={e => this.onChange('level', e)} />
        </FormItem>
        <FormItem label={<span>结果描述</span>} field="describe" {...formItemLayout}>
          <Input value={form.describe.value} className="search_Input" onChange={e => this.onChange('describe', e)} />
        </FormItem>
        <FormItem label={<span>维护人员</span>} field="maintenance" {...formItemLayout}>
          <TreeSelect
            value={form.maintenance.value}
            className="risk_factor_select"
            dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
            treeData={maintenancesData || []}
            placeholder="请选择"
            allowClear
            treeDefaultExpandAll
            onChange={(e, t, obj)  => this.onSelectChange('maintenance', e, t, obj)}
          />
        </FormItem>
      </Form>
    );
  }
}

RiskLevelSearch.propTypes = {

};

export default RiskLevelSearch;
