import React, { Component } from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';
import AmosGridTable from './../../common/tableComponent/table/AmosGridTable';
import AlarmSearch from './AlarmSearch';
import { getFireSourceHistoryDataAction } from '../../../../services/situationService';

const getColumns = () => {
  return [
    {
      title: '序号',
      render: (text, record, index) => `${index + 1}`
    },
    {
      title: '设备编号',
      dataIndex: 'fireEquipmentCode',
      key: 'fireEquipmentCode',
      width: '12%',
      className: 'uant-table-thead'
    },
    {
      title: '设备名称',
      dataIndex: 'fireEquipmentName',
      key: 'fireEquipmentName',
      width: '15%',
      className: 'uant-table-thead'
    },
    {
      title: '指标名称',
      dataIndex: 'eq_point_name',
      key: 'eq_point_name',
      width: '15%',
      className: 'uant-table-thead'
    },
    {
      title: '指标值',
      dataIndex: 'e_value',
      key: 'e_value',
      width: '5%',
      className: 'uant-table-thead'
    },
    {
      title: '指标单位',
      dataIndex: 'eq_point_unit',
      key: 'eq_point_unit',
      width: '10%',
      className: 'uant-table-thead'
    },
    {
      title: '数据类型',
      dataIndex: 'soe',
      key: 'soe',
      width: '10%',
      className: 'uant-table-thead'
    },
    {
      title: '保护对象',
      dataIndex: 'equipmentName',
      key: 'equipmentName',
      width: '15%',
      className: 'uant-table-thead'
    },
    {
      title: '上报时间',
      dataIndex: 'created_time',
      key: 'created_time',
      width: '15%',
      render: text => moment(text).format('YYYY-MM-DD HH:mm:ss'),
      className: 'uant-table-thead'
    }
  ];
};

/**
 * 报警视图
 */
class AlarmView extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      pagination: true,
      isChecked: false,
      selectedRows: [],
      selectedRowKeys: [],
      searchParam: []
    };
  }
  componentDidMount() {}

  /**
   * 分页设置参数
   */
  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.pageNumber = current;
    }
  };

  setSearchParam = searchParam => {
    // let paramArry = new Array();
    // for (let key in searchParam) {
    //   paramArry.push({ name: key, value: searchParam[key] });
    // }
    this.setState({ searchParam }, () => this.questStatistiscData({ pageNumber: this.pageConfig.current - 1, pageSize: this.pageConfig.pageSize }));
  };

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  };

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  questStatistiscData = param => {
    let { searchParam } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    let { pageNumber, pageSize } = param;
    this.queryAlarmList(searchParam, pageNumber, pageSize);
  };

  queryAlarmList = (searchParam, pageNumber, pageSize) => {
    getFireSourceHistoryDataAction(searchParam, pageNumber, pageSize).then(data => {
      this.setState({ dataList: data.content, totalCount: data.totalElements });
    });
  };

  render() {
    let { pagination, isChecked, dataList, totalCount, selectedRowKeys } = this.state;
    let defaultPageConfig = this.pageConfig;
    return (
      <div className="alarm-view">
        <AlarmSearch setSearchParam={this.setSearchParam} />
        <AmosGridTable
          columns={getColumns()}
          callBack={this.reload}
          isPageable={pagination}
          dataList={dataList}
          totals={totalCount}
          getTableDataAction={this.questStatistiscData}
          selectedRowKeys={selectedRowKeys}
          getSelectedRows={this.getSelectedRows}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          onRowDoubleClick={this.onRowDoubleClick}
          isChecked={isChecked}
        />
      </div>
    );
  }
}

AlarmView.propTypes = {};
export default AlarmView;
