import React, { Component } from 'react';
import PropTypes from 'prop-types';
import CheckExecuteHeader from './CheckExecuteHeader';
import CheckExecuteBody from './CheckExecuteBody';
import { getCheckListAction } from './../../../../services/bizService';
/**
 * 巡检执行情况
 *
 * @class CheckExecute
 * @extends {Component}
 */
class CheckExecute extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      pageNumber: 0,
      pageSize: 5
    };
    this.state = {
      data: [],
      totalNum: 0,
      deptId: ''
    };

  }

  componentDidMount() {
    this.getCheckList(this.pageConfig);
  }

  componentWillReceiveProps(nextProps) {
    if (!nextProps.refreshData) {
      return;
    } else {
      let { content } = nextProps.refreshData;
      if (content && content === 'check') {
        this.getCheckList(this.pageConfig);
      }
    }
  }

  onPageChange =(page)=>{
    this.pageConfig.pageNumber = page - 1;
    this.getCheckList(this.pageConfig);
  }

  getCheckList =(pageConfig)=>{
    const { deptId } = this.state;
    const { pageNumber, pageSize } = pageConfig;
    getCheckListAction(pageNumber, pageSize, deptId).then(data=>{
      console.log('check sucdess');
      this.setState({ data: data.list,totalNum: data.count });
    });
  }

  filterList =(deptId)=>{
    this.pageConfig.pageNumber = 0;
    this.setState({ deptId },()=>this.getCheckList(this.pageConfig));
  }

  render() {
    const { data = [],totalNum } = this.state;
    return (
      <div className='check-execute-root'>
        <CheckExecuteHeader filter={this.filterList} />
        <CheckExecuteBody dataList={data} totalPageNum={totalNum} pageSize={this.pageConfig.pageSize} onPageChange={this.onPageChange} />
      </div>
    );
  }
}

CheckExecute.propTypes = {
  refreshData: PropTypes.object
};

export default CheckExecute;
