import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import { getOverdueDangerDataAction } from './../../../../services/situationService';
import BizIcon from '../../../../view/common/icon/BizIcon';

class OverdueStatisticsPie extends Component {
  constructor(props) {
    super(props);
    this.state = {
      indexData: []
    };
  }

  componentDidMount() {
    this.getOverdueStatisticsData();
  }

  componentWillReceiveProps(nextProps) {
    if (!nextProps.refreshData) {
      return;
    } else {
      let { content } = nextProps.refreshData;
      if (content && content === 'dangerOverdue') {
        this.getOverdueStatisticsData();
      }
    }
  }

  getOverdueStatisticsData = () => {
    getOverdueDangerDataAction().then(data => {
      console.log('dangerOverdue sucdess');
      this.setState({ indexData: data });
    });
  }

  getOptions = (obj) => {
    let seriesData = [];
    obj && obj.map(item => {
      let o = {};
      o.value = item.dangerCount;
      o.name = item.departmentName;
      seriesData.push(o);
    });

    return {
      tooltip: {
        trigger: 'item',
        formatter: '{a} <br/>{b} : {c} ({d}%)'
      },
      color: ['#4185f4', '#a055cd', '#cd5583', '#175dcd'],
      series: [
        {
          name: '逾期个数',
          type: 'pie',
          radius: '65%',
          center: ['50%', '55%'],
          selectedMode: 'single',
          data: seriesData,
          label: {
            normal: {
              formatter: '{b}:{d}%'
            }
          },
          itemStyle: {
            emphasis: {
              shadowBlur: 10,
              shadowOffsetX: 0,
              shadowColor: 'rgba(0, 0, 0, 0.5)'
            }
          }
        }
      ]
    };
  }

  render() {
    let { indexData } = this.state;
    let totalCount = 0;
    indexData && indexData.map(i => totalCount += i.dangerCount);
    return (
      <div className="overdue-statistics-pie" >
        <div className="title">
          <BizIcon icon='mokuaidian' className='check-execute-header-icon' />
          <span>隐患治理逾期统计</span>
        </div>
        <div className="content" >
          <AmosEcharts className='overdue-statistics-echarts' option={this.getOptions(indexData)} />
          <span className='overdue-statistics-span' >逾期总数  |  {totalCount}个</span>
        </div>
      </div>
    );
  }
}

OverdueStatisticsPie.propTypes = {
  refreshData: PropTypes.object
};

export default OverdueStatisticsPie;
